/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupService
implements InitializingBean {
    private final Logger Log = LoggerFactory.getLogger(this.getClass());
    private final GroupManager.OnmsGroupListMapper onmsGroupListMapper = new GroupManager.OnmsGroupListMapper();
    private final GroupManager.OnmsGroupMapper onmsGroupMapper = new GroupManager.OnmsGroupMapper();
    @Autowired
    private GroupDao m_groupDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private UserManager m_userDao;

    public GroupService() {
        System.out.println("init...");
    }

    public boolean existsGroup(String groupName) {
        return this.m_groupDao.hasGroup(groupName);
    }

    public Group getGroup(String groupName) {
        return this.m_groupDao.getGroup(groupName);
    }

    public List<Group> getGroups() {
        Collection groups = this.m_groupDao.getGroups().values();
        return groups == null ? new ArrayList<Group>() : new ArrayList(groups);
    }

    public List<OnmsCategory> getAuthorizedCategories(String groupName) {
        return new ArrayList<OnmsCategory>(this.m_categoryDao.getCategoriesWithAuthorizedGroup(groupName));
    }

    public List<String> getAuthorizedCategoriesAsString(String groupName) {
        List<OnmsCategory> categories = this.getAuthorizedCategories(groupName);
        ArrayList<String> categoryNames = new ArrayList<String>(categories.size());
        for (OnmsCategory category : categories) {
            categoryNames.add(category.getName());
        }
        return categoryNames;
    }

    public void saveGroup(OnmsGroup group) {
        this.saveGroup(this.onmsGroupMapper.map(group));
    }

    public void saveGroup(Group group) {
        this.m_groupDao.saveGroup(group.getName(), group);
    }

    public void saveGroup(Group group, List<String> authorizedCategories) {
        this.setAuthorizedCategories(group.getName(), authorizedCategories);
        this.m_groupDao.saveGroup(group.getName(), group);
    }

    public void deleteGroup(String groupName) {
        this.m_groupDao.deleteGroup(groupName);
        this.setAuthorizedCategories(groupName, Collections.<String>emptyList());
    }

    public void renameGroup(String oldName, String newName) {
        this.m_groupDao.renameGroup(oldName, newName);
        List<String> categories = this.getAuthorizedCategoriesAsString(oldName);
        this.setAuthorizedCategories(oldName, Collections.<String>emptyList());
        this.setAuthorizedCategories(newName, categories);
    }

    public boolean addCategory(String groupName, String categoryName) {
        if (this.m_categoryDao.findByName(categoryName) == null) {
            return false;
        }
        List<String> categoryNames = this.getAuthorizedCategoriesAsString(groupName);
        if (!categoryNames.contains(categoryName)) {
            categoryNames.add(categoryName);
            this.saveGroup(this.getGroup(groupName), categoryNames);
            return true;
        }
        return false;
    }

    public boolean removeCategory(String groupName, String categoryName) {
        List<String> categoryNames = this.getAuthorizedCategoriesAsString(groupName);
        if (categoryNames.contains(categoryName)) {
            categoryNames.remove(categoryName);
            this.saveGroup(this.getGroup(groupName), categoryNames);
            return true;
        }
        return false;
    }

    public OnmsGroup getOnmsGroup(String groupName) {
        return this.onmsGroupMapper.map(this.getGroup(groupName));
    }

    public OnmsGroupList getOnmsGroupList() {
        return this.onmsGroupListMapper.map(this.onmsGroupMapper.map(this.getGroups()));
    }

    public OnmsUserList getUsersOfGroup(String groupName) {
        Group group = this.getGroup(groupName);
        OnmsUserList userCollection = new OnmsUserList();
        if (group != null) {
            for (String eachUser : group.getUserCollection()) {
                try {
                    OnmsUser onmsUser = this.m_userDao.getOnmsUser(eachUser);
                    if (onmsUser == null) continue;
                    userCollection.add((Object)onmsUser);
                }
                catch (MarshalException e) {
                    this.Log.error("could not load user", (Throwable)e);
                }
                catch (ValidationException e) {
                    this.Log.error("could not load user", (Throwable)e);
                }
                catch (IOException e) {
                    this.Log.error("could not load user", (Throwable)e);
                }
            }
        }
        return userCollection;
    }

    public OnmsUser getUserForGroup(String groupName, String userName) {
        Group group = this.getGroup(groupName);
        if (group != null && group.getUserCollection().contains(userName)) {
            try {
                return this.m_userDao.getOnmsUser(userName);
            }
            catch (MarshalException e) {
                this.Log.error("could not load user", (Throwable)e);
            }
            catch (ValidationException e) {
                this.Log.error("could not load user", (Throwable)e);
            }
            catch (IOException e) {
                this.Log.error("could not load user", (Throwable)e);
            }
        }
        return null;
    }

    public boolean addUser(String groupName, String userName) {
        Group group = this.getGroup(groupName);
        if (group != null && this.hasUser(userName)) {
            if (this.getUserForGroup(groupName, userName) != null) {
                return false;
            }
            group.addUser(userName);
            this.saveGroup(group);
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    private boolean hasUser(String userName) {
        if (userName != null) {
            try {
                return this.m_userDao.hasUser(userName);
            }
            catch (MarshalException e) {
                this.Log.error("could not load user", (Throwable)e);
            }
            catch (ValidationException e) {
                this.Log.error("could not load user", (Throwable)e);
            }
            catch (IOException e) {
                this.Log.error("could not load user", (Throwable)e);
            }
        }
        return false;
    }

    private void setAuthorizedCategories(String groupName, List<String> categoryNames) {
        List categories = this.m_categoryDao.getCategoriesWithAuthorizedGroup(groupName);
        for (OnmsCategory category : categories) {
            category.getAuthorizedGroups().remove(groupName);
        }
        for (String categoryName : categoryNames) {
            OnmsCategory category = this.m_categoryDao.findByName(categoryName, false);
            if (category == null) continue;
            category.getAuthorizedGroups().add(groupName);
        }
    }
}

