/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.EventFactory;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.rss.AbstractFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFeed
extends AbstractFeed {
    private static final Logger LOG = LoggerFactory.getLogger(EventFeed.class);

    public SyndFeed getFeed(ServletContext servletContext) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Events");
        feed.setDescription("OpenNMS Events");
        feed.setLink(this.getUrlBase() + "event/list.htm");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            Event[] events;
            ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
            if (this.getRequest().getParameter("node") != null) {
                Integer nodeId = WebSecurityUtils.safeParseInt((String)this.getRequest().getParameter("node"));
                filters.add(new NodeFilter((int)nodeId, servletContext));
            }
            if (this.getRequest().getParameter("severity") != null) {
                String parameter = this.getRequest().getParameter("severity");
                try {
                    Integer severityId = WebSecurityUtils.safeParseInt((String)parameter);
                    filters.add(new SeverityFilter(severityId));
                }
                catch (NumberFormatException e) {
                    for (OnmsSeverity sev : OnmsSeverity.values()) {
                        if (!sev.getLabel().equalsIgnoreCase(parameter)) continue;
                        filters.add(new SeverityFilter(sev));
                        break;
                    }
                }
            }
            for (Event event : events = EventFactory.getEvents(SortStyle.TIME, AcknowledgeType.BOTH, filters.toArray(new Filter[0]), this.getMaxEntries(), -1)) {
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setPublishedDate(event.getTime());
                if (event.getAcknowledgeTime() != null) {
                    entry.setTitle(this.sanitizeTitle(event.getLogMessage()) + " (acknowledged by " + event.getAcknowledgeUser() + ")");
                    entry.setUpdatedDate(event.getAcknowledgeTime());
                } else {
                    entry.setTitle(this.sanitizeTitle(event.getLogMessage()));
                    entry.setUpdatedDate(event.getTime());
                }
                entry.setLink(this.getUrlBase() + "event/detail.jsp?id=" + event.getId());
                entries.add(entry);
            }
        }
        catch (SQLException e) {
            LOG.warn("unable to get event(s)", (Throwable)e);
        }
        feed.setEntries(entries);
        return feed;
    }
}

