/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.AlarmUtil;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.NodeFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.rss.AbstractFeed;

public class AlarmFeed
extends AbstractFeed {
    private AlarmRepository m_webAlarmRepository;

    public AlarmFeed() {
        this.initialize();
    }

    public AlarmFeed(String feedType) {
        super(feedType);
        this.initialize();
    }

    private void initialize() {
        this.m_webAlarmRepository = (AlarmRepository)BeanUtils.getBean((String)"daoContext", (String)"alarmRepository", AlarmRepository.class);
    }

    public SyndFeed getFeed(ServletContext servletContext) {
        OnmsAlarm[] alarms;
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Alarms");
        feed.setDescription("OpenNMS Alarms");
        feed.setLink(this.getUrlBase() + "alarm/list.htm");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
        if (this.getRequest().getParameter("node") != null) {
            Integer nodeId = WebSecurityUtils.safeParseInt((String)this.getRequest().getParameter("node"));
            filters.add(new NodeFilter(nodeId, servletContext));
        }
        if (this.getRequest().getParameter("severity") != null) {
            String sev = this.getRequest().getParameter("severity");
            for (OnmsSeverity severity : OnmsSeverity.values()) {
                if (!severity.getLabel().equalsIgnoreCase(sev)) continue;
                filters.add(new SeverityFilter(severity));
            }
        }
        OnmsCriteria queryCriteria = AlarmUtil.getOnmsCriteria(new AlarmCriteria(filters.toArray(new Filter[0]), SortStyle.FIRSTEVENTTIME, AcknowledgeType.BOTH, this.getMaxEntries(), -1));
        for (OnmsAlarm alarm : alarms = this.m_webAlarmRepository.getMatchingAlarms(queryCriteria)) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setPublishedDate(alarm.getFirstEventTime());
            if (alarm.getAckTime() != null) {
                entry.setTitle(this.sanitizeTitle(alarm.getLogMsg()) + " (acknowledged by " + alarm.getAckUser() + ")");
                entry.setUpdatedDate(alarm.getAckTime());
            } else {
                entry.setTitle(this.sanitizeTitle(alarm.getLogMsg()));
                entry.setUpdatedDate(alarm.getFirstEventTime());
            }
            entry.setLink(this.getUrlBase() + "alarm/detail.htm?id=" + alarm.getId());
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }
}

