/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletRequest;
import org.opennms.web.rss.Feed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFeed
implements Feed {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFeed.class);
    protected int m_maxEntries = 20;
    protected String m_feedType = "rss_2.0";
    protected String m_urlBase = "";
    protected ServletRequest m_servletRequest;

    public AbstractFeed() {
    }

    public AbstractFeed(String feedType) {
        this.setFeedType(feedType);
    }

    @Override
    public String getUrlBase() {
        return this.m_urlBase;
    }

    @Override
    public void setUrlBase(String urlBase) {
        this.m_urlBase = urlBase;
    }

    @Override
    public String getFeedType() {
        return this.m_feedType;
    }

    @Override
    public void setFeedType(String feedType) {
        this.m_feedType = feedType;
    }

    @Override
    public int getMaxEntries() {
        return this.m_maxEntries;
    }

    @Override
    public void setMaxEntries(int maxEntries) {
        this.m_maxEntries = maxEntries;
    }

    @Override
    public ServletRequest getRequest() {
        return this.m_servletRequest;
    }

    @Override
    public void setRequest(ServletRequest request) {
        this.m_servletRequest = request;
    }

    public SyndFeed getFeed() {
        return new SyndFeedImpl();
    }

    @Override
    public String render() {
        SyndFeed feed = this.getFeed();
        feed.setFeedType(this.getFeedType());
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            StringWriter writer = new StringWriter();
            output.output(feed, (Writer)writer);
            return writer.toString();
        }
        catch (Throwable e) {
            LOG.warn("unable to render feed", e);
            return "";
        }
    }

    protected String sanitizeTitle(String title) {
        return title.replaceAll("<.*?>", "");
    }
}

