/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.ConfigurationResource;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.monitoringLocations.MonitoringLocationsConfiguration;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@PerRequest
@Scope(value="prototype")
public class PollerConfigurationResource {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigurationResource.class);
    @Resource(name="poller-configuration.xml")
    private ConfigurationResource<PollerConfiguration> m_pollerConfigResource;
    @Resource(name="monitoring-locations.xml")
    private ConfigurationResource<MonitoringLocationsConfiguration> m_monitoringLocationsConfigResource;
    @Context
    private ResourceContext m_context;
    @Context
    private UriInfo m_uriInfo;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getPollerConfigurationForLocation(@PathParam(value="location") String location) throws ConfigurationResourceException {
        LOG.info("getPollerConfigurationForLocation(location={})", (Object)location);
        MonitoringLocationsConfiguration monitoringConfig = (MonitoringLocationsConfiguration)this.m_monitoringLocationsConfigResource.get();
        LOG.debug("monitoring config: {}", (Object)monitoringConfig);
        LocationDef def = monitoringConfig.getLocation(location);
        if (def == null) {
            LOG.warn("Unable to find monitoring location {}", (Object)location);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String pollingPackageName = def.getPollingPackageName();
        if (pollingPackageName == null || "".equals(pollingPackageName)) {
            LOG.warn("Monitoring location {} does not have a polling package defined.", (Object)location);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PollerConfiguration pollerConfig = ((PollerConfiguration)this.m_pollerConfigResource.get()).getPollerConfigurationForPackage(pollingPackageName);
        return Response.ok((Object)pollerConfig).build();
    }
}

