/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@PerRequest
@Scope(value="prototype")
public class DataCollectionConfigResource
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionConfigResource.class);
    @Resource(name="dataCollectionConfigDao")
    private DataCollectionConfigDao m_dataCollectionConfigDao;
    @Context
    private ResourceContext m_context;
    @Context
    private UriInfo m_uriInfo;

    public void setDataCollectionConfigDao(DataCollectionConfigDao dao) {
        this.m_dataCollectionConfigDao = dao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_dataCollectionConfigDao, (String)"DataCollectionConfigDao must be set!");
        Assert.isTrue((boolean)(this.m_dataCollectionConfigDao instanceof AbstractJaxbConfigDao));
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getDataCollectionConfiguration() throws ConfigurationResourceException {
        LOG.info("getDatacollectionConfigurationForLocation()");
        AbstractJaxbConfigDao dao = (AbstractJaxbConfigDao)this.m_dataCollectionConfigDao;
        DatacollectionConfig dcc = (DatacollectionConfig)dao.getContainer().getObject();
        if (dcc == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)dcc.toDataCollectionConfig()).build();
    }
}

