/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.ConfigurationResource;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.config.agents.AgentResponse;
import org.opennms.netmgt.config.agents.AgentResponseCollection;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@PerRequest
@Scope(value="prototype")
public class AgentConfigurationResource
implements InitializingBean {
    private static Logger LOG = LoggerFactory.getLogger(AgentConfigurationResource.class);
    @Resource(name="collectd-configuration.xml")
    private ConfigurationResource<CollectdConfiguration> m_collectdConfigurationResource;
    @Autowired
    private FilterDao m_filterDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private SnmpAgentConfigFactory m_agentConfigFactory;
    @Context
    private ResourceContext m_context;
    @Context
    private UriInfo m_uriInfo;

    public void setCollectdConfigurationResource(ConfigurationResource<CollectdConfiguration> resource) {
        this.m_collectdConfigurationResource = resource;
    }

    public void setFilterDao(FilterDao dao) {
        this.m_filterDao = dao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao dao) {
        this.m_monitoredServiceDao = dao;
    }

    public void setAgentConfigFactory(SnmpAgentConfigFactory factory) {
        this.m_agentConfigFactory = factory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.m_collectdConfigurationResource, (String)"CollectdConfigurationResource must not be null.");
        Assert.notNull((Object)this.m_filterDao, (String)"FilterDao must not be null.");
        Assert.notNull((Object)this.m_monitoredServiceDao, (String)"MonitoredServiceDao must not be null.");
        Assert.notNull((Object)this.m_agentConfigFactory, (String)"SnmpConfigDao must not be null.");
    }

    @GET
    @Path(value="{filterName}/{serviceName}.xml")
    @Produces(value={"application/xml", "application/atom+xml"})
    public Response getAgentsXmlWithExtension(@PathParam(value="filterName") String filterName, @PathParam(value="serviceName") String serviceName) throws ConfigurationResourceException {
        return this.getAgentsXml(filterName, serviceName);
    }

    @GET
    @Path(value="{filterName}/{serviceName}")
    @Produces(value={"application/xml", "application/atom+xml"})
    public Response getAgentsXmlWithoutExtension(@PathParam(value="filterName") String filterName, @PathParam(value="serviceName") String serviceName) throws ConfigurationResourceException {
        return this.getAgentsXml(filterName, serviceName);
    }

    public Response getAgentsXml(String filterName, String serviceName) throws ConfigurationResourceException {
        List<AgentResponse> responses = this.getResponses(filterName, serviceName);
        if (responses.size() == 0) {
            return Response.noContent().build();
        }
        return Response.ok((Object)new AgentResponseCollection(responses)).build();
    }

    @GET
    @Path(value="{filterName}/{serviceName}.json")
    @Produces(value={"application/json"})
    public Response getAgentsJsonWithExtension(@PathParam(value="filterName") String filterName, @PathParam(value="serviceName") String serviceName) throws ConfigurationResourceException {
        return this.getAgentsJson(filterName, serviceName);
    }

    @GET
    @Path(value="{filterName}/{serviceName}")
    @Produces(value={"application/json"})
    public Response getAgentsJsonWithoutExtension(@PathParam(value="filterName") String filterName, @PathParam(value="serviceName") String serviceName) throws ConfigurationResourceException {
        return this.getAgentsJson(filterName, serviceName);
    }

    public Response getAgentsJson(String filterName, String serviceName) throws ConfigurationResourceException {
        List<AgentResponse> responses = this.getResponses(filterName, serviceName);
        if (responses.size() == 0) {
            return Response.noContent().build();
        }
        return Response.ok((Object)new GenericEntity<List<AgentResponse>>(responses){}).build();
    }

    protected List<AgentResponse> getResponses(String filterName, String serviceName) throws ConfigurationResourceException {
        Service svc;
        String port;
        LOG.debug("getAgentsForService(): filterName={}, serviceName={}", (Object)filterName, (Object)serviceName);
        if (filterName == null || serviceName == null) {
            throw new IllegalArgumentException("You must specify a filter name and service name!");
        }
        Filter filter = ((CollectdConfiguration)this.m_collectdConfigurationResource.get()).getFilter(filterName);
        if (filter == null) {
            LOG.warn("No filter matching {} could be found.", (Object)filterName);
            throw new WebApplicationException(404);
        }
        List addresses = this.m_filterDao.getActiveIPAddressList(filter.getContent());
        LOG.debug("Matched {} IP addresses for filter {}", (Object)(addresses == null ? 0 : addresses.size()), (Object)filterName);
        if (addresses == null || addresses.size() == 0) {
            return Collections.emptyList();
        }
        CriteriaBuilder builder = new CriteriaBuilder(OnmsMonitoredService.class);
        builder.createAlias("ipInterface", "iface");
        builder.createAlias("serviceType", "type");
        builder.createAlias("iface.node", "node");
        builder.in("iface.ipAddress", (Collection)addresses);
        builder.eq("type.name", (Object)serviceName);
        List services = this.m_monitoredServiceDao.findMatching(builder.toCriteria());
        int defaultPort = -1;
        CollectdConfiguration collectdConfiguration = (CollectdConfiguration)this.m_collectdConfigurationResource.get();
        Package pack = collectdConfiguration.getPackage(filterName);
        if (pack == null) {
            for (Package p : collectdConfiguration.getPackages()) {
                if (!filterName.equals(p.getFilter().getName())) continue;
                pack = p;
                break;
            }
        }
        if (pack != null && (port = (svc = pack.getService(serviceName)).getParameter("port")) != null) {
            try {
                defaultPort = Integer.valueOf(port);
            }
            catch (NumberFormatException e) {
                LOG.debug("Unable to turn port {} from service {} into a number.", (Object)port, (Object)serviceName);
            }
        }
        ArrayList<AgentResponse> responses = new ArrayList<AgentResponse>();
        for (OnmsMonitoredService service : services) {
            InetAddress ipAddress = service.getIpAddress();
            OnmsIpInterface iface = service.getIpInterface();
            OnmsNode node = null;
            if (iface != null) {
                node = iface.getNode();
            }
            TreeMap<String, String> parameters = new TreeMap<String, String>();
            int port2 = defaultPort;
            if ("SNMP".equals(serviceName)) {
                SnmpAgentConfig config;
                String sysObjectId;
                String string = sysObjectId = node == null ? null : node.getSysObjectId();
                if (sysObjectId != null) {
                    parameters.put("sysObjectId", sysObjectId);
                }
                if ((config = this.m_agentConfigFactory.getAgentConfig(ipAddress)) != null) {
                    port2 = config.getPort();
                }
            }
            if (node != null) {
                if (node.getNodeId() != null && !node.getNodeId().trim().isEmpty()) {
                    parameters.put("nodeId", node.getNodeId());
                }
                if (node.getForeignSource() != null && !node.getForeignSource().trim().isEmpty()) {
                    parameters.put("foreignSource", node.getForeignSource());
                }
                if (node.getForeignId() != null && !node.getForeignId().trim().isEmpty()) {
                    parameters.put("foreignId", node.getForeignId());
                }
            }
            responses.add(new AgentResponse(ipAddress, Integer.valueOf(port2), service.getServiceName(), parameters));
        }
        return responses;
    }
}

