/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.beans.PropertyEditor;
import java.net.InetAddress;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSeverityEditor;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.PrimaryTypeEditor;
import org.opennms.netmgt.provision.persist.StringXmlCalendarPropertyEditor;
import org.opennms.web.rest.ISO8601DateEditor;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.rest.support.InetAddressTypeEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class RestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RestUtils.class);

    public static void setBeanProperties(Object bean, MultivaluedMapImpl properties) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
        wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
        wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
        for (String key : properties.keySet()) {
            String propertyName = OnmsRestService.convertNameToPropertyName(key);
            if (!wrapper.isWritableProperty(propertyName)) continue;
            String stringValue = properties.getFirst(key);
            Object value = RestUtils.convertIfNecessary(wrapper, propertyName, stringValue);
            wrapper.setPropertyValue(propertyName, value);
        }
    }

    private static Object convertIfNecessary(BeanWrapper wrapper, String propertyName, String stringValue) {
        LOG.debug("convertIfNecessary({}, {})", (Object)propertyName, (Object)stringValue);
        return wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(propertyName));
    }
}

