/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.OnmsMapDao;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElementList;
import org.opennms.web.rest.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsMapElementResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsMapElementResource.class);
    @Autowired
    private OnmsMapDao m_mapDao;
    @Context
    ResourceContext m_context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMapElementList getMapElements(@PathParam(value="mapId") int mapId) {
        this.readLock();
        try {
            LOG.debug("getMapElements: reading elements for map {}", (Object)mapId);
            OnmsMap map = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
            if (map == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getMapElements: can't find map " + mapId, new String[0]);
            }
            OnmsMapElementList onmsMapElementList = new OnmsMapElementList((Collection)map.getMapElements());
            return onmsMapElementList;
        }
        finally {
            this.readUnlock();
        }
    }
}

