/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsNotificationCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="notifications")
public class NotificationRestService
extends OnmsRestService {
    @Autowired
    private NotificationDao m_notifDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{notifId}")
    @Transactional
    public OnmsNotification getNotification(@PathParam(value="notifId") String notifId) {
        this.readLock();
        try {
            OnmsNotification result;
            OnmsNotification onmsNotification = result = (OnmsNotification)this.m_notifDao.get((Serializable)new Integer(notifId));
            return onmsNotification;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_notifDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsNotificationCollection getNotifications() {
        this.readLock();
        try {
            CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters());
            builder.orderBy("notifyId").desc();
            OnmsNotificationCollection coll = new OnmsNotificationCollection((Collection)this.m_notifDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(Integer.valueOf(this.m_notifDao.countMatching(builder.count().toCriteria())));
            OnmsNotificationCollection onmsNotificationCollection = coll;
            return onmsNotificationCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{notifId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateNotification(@PathParam(value="notifId") String notifId, @FormParam(value="ack") Boolean ack) {
        this.writeLock();
        try {
            OnmsNotification notif = (OnmsNotification)this.m_notifDao.get((Serializable)new Integer(notifId));
            if (ack == null) {
                throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
            }
            this.processNotifAck(notif, ack);
            Response response = Response.seeOther((URI)this.m_uriInfo.getBaseUriBuilder().path(this.getClass()).path(this.getClass(), "getNotification").build(new Object[]{notifId})).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateNotifications(MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Boolean ack = false;
            if (params.containsKey("ack")) {
                ack = "true".equals(params.getFirst("ack"));
                params.remove("ack");
            }
            CriteriaBuilder builder = this.getCriteriaBuilder(params);
            for (OnmsNotification notif : this.m_notifDao.findMatching(builder.toCriteria())) {
                this.processNotifAck(notif, ack);
            }
            Response response = Response.seeOther((URI)this.m_uriInfo.getBaseUriBuilder().path(this.getClass()).path(this.getClass(), "getNotifications").build(new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void processNotifAck(OnmsNotification notif, Boolean ack) {
        if (ack.booleanValue()) {
            notif.setRespondTime(new Date());
            notif.setAnsweredBy(this.m_securityContext.getUserPrincipal().getName());
        } else {
            notif.setRespondTime(null);
            notif.setAnsweredBy(null);
        }
        this.m_notifDao.save((Object)notif);
    }

    private CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNotification.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("event", "event", Alias.JoinType.LEFT_JOIN);
        builder.alias("usersNotified", "usersNotified", Alias.JoinType.LEFT_JOIN);
        this.applyQueryFilters(params, builder);
        return builder;
    }
}

