/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.rest.AssetRecordResource;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsIpInterfaceResource;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.rest.OnmsSnmpInterfaceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="nodes")
@Transactional
public class NodeRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRestService.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public OnmsNodeList getNodes() {
        this.readLock();
        try {
            MultivaluedMap params = this.m_uriInfo.getQueryParameters();
            String type = (String)params.getFirst((Object)"type");
            CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)params);
            builder.orderBy("label").asc();
            Criteria crit = builder.toCriteria();
            if (type == null) {
                ArrayList<Restriction> restrictions = new ArrayList<Restriction>(crit.getRestrictions());
                restrictions.add(Restrictions.ne((String)"type", (Object)"D"));
                crit.setRestrictions(restrictions);
            }
            OnmsNodeList coll = new OnmsNodeList((Collection)this.m_nodeDao.findMatching(crit));
            crit.setLimit(null);
            crit.setOffset(null);
            crit.setOrders(new ArrayList());
            coll.setTotalCount(Integer.valueOf(this.m_nodeDao.countMatching(crit)));
            OnmsNodeList onmsNodeList = coll;
            return onmsNodeList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{nodeCriteria}")
    public OnmsNode getNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.readLock();
        try {
            OnmsNode onmsNode = this.m_nodeDao.get(nodeCriteria);
            return onmsNode;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addNode(OnmsNode node) {
        this.writeLock();
        try {
            LOG.debug("addNode: Adding node {}", (Object)node);
            this.m_nodeDao.save((Object)node);
            try {
                this.sendEvent("uei.opennms.org/nodes/nodeAdded", node.getId(), node.getLabel());
            }
            catch (EventProxyException ex) {
                throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
            }
            Response response = Response.seeOther((URI)this.m_uriInfo.getRequestUriBuilder().path(node.getNodeId()).build(new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{nodeCriteria}")
    public Response updateNode(@PathParam(value="nodeCriteria") String nodeCriteria, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateNode: Can't find node " + nodeCriteria, new String[0]);
            }
            LOG.debug("updateNode: updating node {}", (Object)node);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)node);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateNode: node {} updated", (Object)node);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.seeOther((URI)NodeRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{nodeCriteria}")
    public Response deleteNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteNode: Can't find node " + nodeCriteria, new String[0]);
            }
            LOG.debug("deleteNode: deleting node {}", (Object)nodeCriteria);
            this.m_nodeDao.delete((Object)node);
            try {
                this.sendEvent("uei.opennms.org/nodes/nodeDeleted", node.getId(), node.getLabel());
            }
            catch (EventProxyException ex) {
                throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Path(value="{nodeCriteria}/ipinterfaces")
    public OnmsIpInterfaceResource getIpInterfaceResource() {
        return (OnmsIpInterfaceResource)this.m_context.getResource(OnmsIpInterfaceResource.class);
    }

    @Path(value="{nodeCriteria}/snmpinterfaces")
    public OnmsSnmpInterfaceResource getSnmpInterfaceResource() {
        return (OnmsSnmpInterfaceResource)this.m_context.getResource(OnmsSnmpInterfaceResource.class);
    }

    @Path(value="{nodeCriteria}/assetRecord")
    public AssetRecordResource getAssetRecordResource() {
        return (AssetRecordResource)this.m_context.getResource(AssetRecordResource.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{nodeCriteria}/categories")
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategoryCollection getCategoriesForNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getCategories: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsCategoryCollection onmsCategoryCollection = new OnmsCategoryCollection((Collection)node.getCategories());
            return onmsCategoryCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public OnmsCategory getCategoryForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getCategory: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsCategory onmsCategory = this.getCategory(node, categoryName);
            return onmsCategory;
        }
        finally {
            this.readUnlock();
        }
    }

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/{nodeCriteria}/categories")
    public Response addCategoryToNode(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsCategory category) {
        if (category == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Category must not be null.", new String[0]);
        }
        return this.addCategoryToNode(nodeCriteria, category.getName());
    }

    @PUT
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public Response addCategoryToNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addCategory: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsCategory found = this.m_categoryDao.findByName(categoryName);
            if (found == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addCategory: Can't find category " + categoryName, new String[0]);
            }
            if (!node.getCategories().contains(found)) {
                LOG.debug("addCategory: Adding category {} to node {}", (Object)found, (Object)nodeCriteria);
                node.addCategory(found);
                this.m_nodeDao.save((Object)node);
                Response response = Response.seeOther((URI)NodeRestService.getRedirectUri(this.m_uriInfo, categoryName)).build();
                return response;
            }
            throw this.getException(Response.Status.BAD_REQUEST, "addCategory: Category '{}' already added to node '{}'", categoryName, nodeCriteria);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public Response updateCategoryForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateCategory: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsCategory category = this.getCategory(node, categoryName);
            if (category == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateCategory: Category " + categoryName + " not found on node " + nodeCriteria, new String[0]);
            }
            LOG.debug("updateCategory: updating category {}", (Object)category);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)category);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateCategory: category {} updated", (Object)category);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.seeOther((URI)NodeRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public Response removeCategoryFromNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteCaegory: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsCategory category = this.getCategory(node, categoryName);
            if (category == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteCaegory: Category " + categoryName + " not found on node " + nodeCriteria, new String[0]);
            }
            LOG.debug("deleteCaegory: deleting category {} from node {}", (Object)categoryName, (Object)nodeCriteria);
            node.getCategories().remove(category);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private OnmsCategory getCategory(OnmsNode node, String categoryName) {
        for (OnmsCategory category : node.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        return null;
    }

    private void sendEvent(String uei, int nodeId, String nodeLabel) throws EventProxyException {
        EventBuilder bldr = new EventBuilder(uei, this.getClass().getName());
        bldr.setNodeid((long)nodeId);
        bldr.addParam("nodelabel", nodeLabel);
        this.m_eventProxy.send(bldr.getEvent());
    }

    private CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("categories", "category", Alias.JoinType.LEFT_JOIN);
        builder.alias("assetRecord", "assetRecord", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces.monitoredServices.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        this.applyQueryFilters(params, builder);
        return builder;
    }
}

