/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.svclayer.KscReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="ksc")
public class KscRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(KscRestService.class);
    @Autowired
    private KscReportService m_kscReportService;
    @Autowired
    private KSC_PerformanceReportFactory m_kscReportFactory;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public KscReportCollection getReports() throws ParseException {
        this.readLock();
        try {
            KscReportCollection reports = new KscReportCollection(this.m_kscReportService.getReportList());
            reports.setTotalCount(reports.size());
            KscReportCollection kscReportCollection = reports;
            return kscReportCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{reportId}")
    @Transactional
    public KscReport getReport(@PathParam(value="reportId") Integer reportId) {
        this.readLock();
        try {
            Map<Integer, String> reportList = this.m_kscReportService.getReportList();
            String label = reportList.get(reportId);
            if (label == null) {
                throw this.getException(Response.Status.NOT_FOUND, "No such report id " + reportId, new String[0]);
            }
            KscReport kscReport = new KscReport(reportId, label);
            return kscReport;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_kscReportService.getReportList().size());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{kscReportId}")
    @Transactional
    public Response addGraph(@PathParam(value="kscReportId") Integer kscReportId, @QueryParam(value="title") String title, @QueryParam(value="reportName") String reportName, @QueryParam(value="resourceId") String resourceId, @QueryParam(value="timespan") String timespan) {
        this.writeLock();
        try {
            if (kscReportId == null || reportName == null || reportName == "" || resourceId == null || resourceId == "") {
                throw this.getException(Response.Status.BAD_REQUEST, "Invalid request: reportName and resourceId cannot be empty!", new String[0]);
            }
            Report report = this.m_kscReportFactory.getReportByIndex(kscReportId.intValue());
            if (report == null) {
                throw this.getException(Response.Status.NOT_FOUND, "Invalid request: No KSC report found with ID: " + kscReportId, new String[0]);
            }
            Graph graph = new Graph();
            if (title != null) {
                graph.setTitle(title);
            }
            boolean found = false;
            for (String valid : KSC_PerformanceReportFactory.TIMESPAN_OPTIONS) {
                if (!valid.equals(timespan)) continue;
                found = true;
                break;
            }
            if (!found) {
                LOG.debug("invalid timespan ('{}'), setting to '7_day' instead.", (Object)timespan);
                timespan = "7_day";
            }
            graph.setGraphtype(reportName);
            graph.setResourceId(resourceId);
            graph.setTimespan(timespan);
            report.addGraph(graph);
            this.m_kscReportFactory.setReport(kscReportId.intValue(), report);
            try {
                this.m_kscReportFactory.saveCurrent();
            }
            catch (Exception e) {
                throw this.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
            }
            Response response = Response.seeOther((URI)KscRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Entity
    @XmlRootElement(name="kscReport")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class KscReport {
        @XmlAttribute(name="id", required=true)
        private Integer m_id;
        @XmlAttribute(name="label", required=true)
        private String m_label;

        public KscReport() {
        }

        public KscReport(Integer reportId, String label) {
            this.m_id = reportId;
            this.m_label = label;
        }

        public Integer getId() {
            return this.m_id;
        }

        public void setId(Integer id) {
            this.m_id = id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }
    }

    @Entity
    @XmlRootElement(name="kscReports")
    public static final class KscReportCollection
    extends JaxbListWrapper<KscReport> {
        private static final long serialVersionUID = 1L;

        public KscReportCollection() {
        }

        public KscReportCollection(Collection<? extends KscReport> reports) {
            super(reports);
        }

        public KscReportCollection(Map<Integer, String> reportList) {
            for (Integer key : reportList.keySet()) {
                this.add(new KscReport(key, reportList.get(key)));
            }
        }

        @XmlElement(name="kscReport")
        public List<KscReport> getObjects() {
            return super.getObjects();
        }
    }
}

