/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoredServiceDetail;
import org.opennms.netmgt.model.OnmsMonitoredServiceDetailList;
import org.opennms.netmgt.model.OnmsMonitoredServiceList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="ifservices")
@Transactional
public class IfServicesRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(IfServicesRestService.class);
    @Autowired
    private MonitoredServiceDao m_serviceDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    private UriInfo m_uriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public OnmsMonitoredServiceDetailList getServices() {
        this.readLock();
        try {
            Criteria c = this.getCriteria((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters());
            OnmsMonitoredServiceDetailList servicesList = new OnmsMonitoredServiceDetailList();
            List services = this.m_serviceDao.findMatching(c);
            for (OnmsMonitoredService svc : services) {
                servicesList.add((Object)new OnmsMonitoredServiceDetail(svc));
            }
            c.setLimit(null);
            c.setOffset(null);
            c.setOrders(new ArrayList());
            servicesList.setTotalCount(Integer.valueOf(this.m_serviceDao.countMatching(c)));
            OnmsMonitoredServiceDetailList onmsMonitoredServiceDetailList = servicesList;
            return onmsMonitoredServiceDetailList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    public Response updateServices(MultivaluedMapImpl params) {
        this.readLock();
        try {
            String status = params.getFirst("status");
            if (status == null || !status.matches("(A|R|S|F)")) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateServices: parameter status must be specified. Possible values: A (Managed), F (Forced Unmanaged), R (Rescan to Resume), S (Rescan to Suspend)", new String[0]);
            }
            String services_csv = params.getFirst("services");
            ArrayList<String> serviceList = new ArrayList<String>();
            if (services_csv != null) {
                for (String s : services_csv.split(",")) {
                    serviceList.add(s);
                }
            }
            Criteria c = this.getCriteria((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters());
            c.setLimit(null);
            c.setOffset(null);
            OnmsMonitoredServiceList services = new OnmsMonitoredServiceList((Collection)this.m_serviceDao.findMatching(c));
            if (services.isEmpty()) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateServices: can't find any service matchinng the provided criteria: " + this.m_uriInfo.getQueryParameters(), new String[0]);
            }
            boolean modified = false;
            for (OnmsMonitoredService svc : services) {
                boolean proceed = false;
                if (serviceList.isEmpty()) {
                    proceed = true;
                } else if (serviceList.contains(svc.getServiceName())) {
                    proceed = true;
                }
                if (!proceed) continue;
                modified = true;
                String currentStatus = svc.getStatus();
                svc.setStatus(status);
                this.m_serviceDao.update((Object)svc);
                if ("S".equals(status) || currentStatus.equals("A") && status.equals("F")) {
                    LOG.debug("updateServices: suspending polling for service {} on node with IP {}", (Object)svc.getServiceName(), (Object)svc.getIpAddress().getHostAddress());
                    this.sendEvent("uei.opennms.org/nodes/serviceUnmanaged", svc);
                    this.sendEvent("uei.opennms.org/internal/poller/suspendPollingService", svc);
                }
                if (!"R".equals(status) && (!currentStatus.equals("F") || !status.equals("A"))) continue;
                LOG.debug("updateServices: resuming polling for service {} on node with IP {}", (Object)svc.getServiceName(), (Object)svc.getIpAddress().getHostAddress());
                this.sendEvent("uei.opennms.org/internal/poller/resumePollingService", svc);
            }
            if (!modified && !serviceList.isEmpty()) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateServices: the supplied list of services (" + services_csv + ") doesn't match any service based on the provided criteria: " + this.m_uriInfo.getQueryParameters(), new String[0]);
            }
        }
        finally {
            this.readUnlock();
        }
        return Response.seeOther((URI)IfServicesRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
    }

    private Criteria getCriteria(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsMonitoredService.class);
        builder.alias("ipInterface.snmpInterface", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.node.categories", "category", Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        this.applyQueryFilters(params, builder);
        Criteria criteria = builder.toCriteria();
        return criteria;
    }

    private void sendEvent(String eventUEI, OnmsMonitoredService dbObj) {
        EventBuilder bldr = new EventBuilder(eventUEI, this.getClass().getName());
        bldr.setNodeid((long)dbObj.getNodeId().intValue());
        bldr.setInterface(dbObj.getIpAddress());
        bldr.setService(dbObj.getServiceName());
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException ex) {
            throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
        }
    }
}

