/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.DataLinkInterfaceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="links")
@Transactional
public class DataLinkInterfaceRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(DataLinkInterfaceRestService.class);
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public DataLinkInterfaceList getLinks() {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            builder.orderBy("lastPollTime").desc();
            DataLinkInterfaceList dataLinkInterfaceList = new DataLinkInterfaceList((Collection)this.m_dataLinkInterfaceDao.findMatching(builder.toCriteria()));
            return dataLinkInterfaceList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{linkId}")
    @Transactional(readOnly=true)
    public DataLinkInterface getLink(@PathParam(value="linkId") Integer linkId) {
        this.readLock();
        try {
            DataLinkInterface dataLinkInterface = (DataLinkInterface)this.m_dataLinkInterfaceDao.get((Serializable)linkId);
            return dataLinkInterface;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{linkId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateDataLinkInterface(@PathParam(value="linkId") Integer linkId, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            LOG.debug("updateDataLinkInterface: Updating DataLinkInterface with ID {}", (Object)linkId);
            DataLinkInterface iface = (DataLinkInterface)this.m_dataLinkInterfaceDao.get((Serializable)linkId);
            if (iface != null) {
                this.setProperties(params, iface);
                LOG.debug("updateDataLinkInterface: DataLinkInterface with ID {} updated", (Object)linkId);
                this.m_dataLinkInterfaceDao.saveOrUpdate((Object)iface);
                Response response = Response.seeOther((URI)DataLinkInterfaceRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
                return response;
            }
            Response response = Response.notModified((String)linkId.toString()).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceDataLinkInterface(DataLinkInterface iface) {
        this.writeLock();
        try {
            if (iface.getNode() == null && iface.getNodeId() != null) {
                iface.setNode((OnmsNode)this.m_nodeDao.get((Serializable)iface.getNodeId()));
            }
            if (iface.getSource() == null) {
                iface.setSource("rest");
            }
            LOG.debug("addOrReplaceDataLinkInterface: Adding data link interface {}", (Object)iface);
            this.m_dataLinkInterfaceDao.saveOrUpdate((Object)iface);
            Response response = Response.seeOther((URI)DataLinkInterfaceRestService.getRedirectUri(this.m_uriInfo, iface.getId())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{linkId}")
    public Response deleteDataLinkInterface(@PathParam(value="linkId") Integer linkId) {
        this.writeLock();
        try {
            LOG.debug("deleteDataLinkInterface: deleting DataLinkInterface with ID {}", (Object)linkId);
            DataLinkInterface iface = (DataLinkInterface)this.m_dataLinkInterfaceDao.get((Serializable)linkId);
            this.m_dataLinkInterfaceDao.delete((Object)iface);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

