/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.web.rest.GroupRestService;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.NodeRestService;
import org.opennms.web.rest.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="categories")
@Transactional
public class CategoryRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryRestService.class);
    @Autowired
    private CategoryDao m_categoryDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/nodes/{nodeCriteria}")
    public OnmsCategoryCollection getCategoriesForNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        return ((NodeRestService)this.m_context.getResource(NodeRestService.class)).getCategoriesForNode(nodeCriteria);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{categoryName}/nodes/{nodeCriteria}")
    public OnmsCategory getCategoryForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        return ((NodeRestService)this.m_context.getResource(NodeRestService.class)).getCategoryForNode(nodeCriteria, categoryName);
    }

    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="{categoryName}/nodes/{nodeCriteria}/")
    public Response addCategoryToNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        return ((NodeRestService)this.m_context.getResource(NodeRestService.class)).addCategoryToNode(nodeCriteria, categoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{categoryName}")
    public Response updateCategory(@PathParam(value="categoryName") String categoryName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsCategory category = this.m_categoryDao.findByName(categoryName);
            if (category == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateCategory: Category " + categoryName + " not found.", new String[0]);
            }
            LOG.debug("updateCategory: updating category {}", (Object)category);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)category);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateCategory: category {} updated", (Object)category);
            this.m_categoryDao.saveOrUpdate((Object)category);
            Response response = Response.seeOther((URI)CategoryRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="/{categoryName}/nodes/{nodeCriteria}/")
    public Response removeCategoryFromNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        return ((NodeRestService)this.m_context.getResource(NodeRestService.class)).removeCategoryFromNode(nodeCriteria, categoryName);
    }

    @GET
    @Path(value="/{categoryName}")
    public OnmsCategory getCategory(@PathParam(value="categoryName") String categoryName) {
        OnmsCategory category = this.m_categoryDao.findByName(categoryName);
        if (category == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Category with name {} was not found.", categoryName);
        }
        return category;
    }

    @POST
    @Path(value="/")
    public Response createCategory(OnmsCategory category) {
        boolean exists;
        if (category == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Category must not be null.", new String[0]);
        }
        boolean bl = exists = this.m_categoryDao.findByName(category.getName()) != null;
        if (!exists) {
            this.m_categoryDao.save((Object)category);
            return Response.seeOther((URI)CategoryRestService.getRedirectUri(this.m_uriInfo, category.getName())).build();
        }
        throw this.getException(Response.Status.BAD_REQUEST, "A category with name '{}' already exists.", category.getName());
    }

    @GET
    @Path(value="/")
    public OnmsCategoryCollection listCategories() {
        return new OnmsCategoryCollection(new ArrayList(this.m_categoryDao.findAll()));
    }

    @DELETE
    @Path(value="/{categoryName}")
    public Response deleteCategory(@PathParam(value="categoryName") String categoryName) {
        OnmsCategory category = this.m_categoryDao.findByName(categoryName);
        if (category != null) {
            this.m_categoryDao.delete((Object)category);
            return Response.seeOther((URI)CategoryRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
        }
        throw this.getException(Response.Status.BAD_REQUEST, "A category with name '{}' does not exist.", categoryName);
    }

    @PUT
    @Path(value="/{categoryName}/groups/{groupName}")
    public OnmsCategory addCategoryToGroup(@PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        return ((GroupRestService)this.m_context.getResource(GroupRestService.class)).addCategory(groupName, categoryName);
    }

    @DELETE
    @Path(value="/{categoryName}/groups/{groupName}")
    public Response removeCategoryFromGroup(@PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        return ((GroupRestService)this.m_context.getResource(GroupRestService.class)).removeCategory(groupName, categoryName);
    }

    @GET
    @Path(value="/groups/{groupName}")
    public OnmsCategoryCollection listCategoriesForGroup(@PathParam(value="groupName") String groupName) {
        return ((GroupRestService)this.m_context.getResource(GroupRestService.class)).listCategories(groupName);
    }
}

