/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="assetRecord")
@Transactional
public class AssetRecordResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(AssetRecordResource.class);
    @Context
    UriInfo m_uriInfo;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private EventProxy m_eventProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsAssetRecord getAssetRecord(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getCategories: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsAssetRecord onmsAssetRecord = this.getAssetRecord(node);
            return onmsAssetRecord;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateAssetRecord(@PathParam(value="nodeCriteria") String nodeCriteria, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateAssetRecord: Can't find node " + nodeCriteria, new String[0]);
            }
            OnmsAssetRecord assetRecord = this.getAssetRecord(node);
            if (assetRecord == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateAssetRecord: Node " + node + " could not update ", new String[0]);
            }
            LOG.debug("updateAssetRecord: updating category {}", (Object)assetRecord);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)assetRecord);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateAssetRecord: assetRecord {} updated", (Object)assetRecord);
            this.m_nodeDao.saveOrUpdate((Object)node);
            try {
                this.sendEvent("uei.opennms.org/nodes/assetInfoChanged", node.getId());
            }
            catch (EventProxyException e) {
                throw this.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
            }
            Response response = Response.seeOther((URI)AssetRecordResource.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private OnmsAssetRecord getAssetRecord(OnmsNode node) {
        return node.getAssetRecord();
    }

    private void sendEvent(String uei, int nodeId) throws EventProxyException {
        EventBuilder bldr = new EventBuilder(uei, this.getClass().getName());
        bldr.setNodeid((long)nodeId);
        this.m_eventProxy.send(bldr.getEvent());
    }
}

