/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAlarmCollection;
import org.opennms.web.rest.AlarmRestServiceBase;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="alarms")
public class AlarmRestService
extends AlarmRestServiceBase {
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private AcknowledgmentDao m_ackDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{alarmId}")
    @Transactional
    public OnmsAlarm getAlarm(@PathParam(value="alarmId") String alarmId) {
        this.readLock();
        try {
            OnmsAlarm onmsAlarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)new Integer(alarmId));
            return onmsAlarm;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_alarmDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsAlarmCollection getAlarms() {
        this.readLock();
        try {
            CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), false);
            builder.distinct();
            OnmsAlarmCollection coll = new OnmsAlarmCollection((Collection)this.m_alarmDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(Integer.valueOf(this.m_alarmDao.countMatching(builder.clearOrder().limit(Integer.valueOf(0)).offset(Integer.valueOf(0)).toCriteria())));
            OnmsAlarmCollection onmsAlarmCollection = coll;
            return onmsAlarmCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{alarmId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateAlarm(@PathParam(value="alarmId") Integer alarmId, MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            if (alarmId == null) {
                throw new IllegalArgumentException("Unable to determine alarm ID to update based on query path.");
            }
            String ackValue = formProperties.getFirst("ack");
            formProperties.remove("ack");
            String escalateValue = formProperties.getFirst("escalate");
            formProperties.remove("escalate");
            String clearValue = formProperties.getFirst("clear");
            formProperties.remove("clear");
            String ackUserValue = formProperties.getFirst("ackUser");
            formProperties.remove("ackUser");
            OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)alarmId);
            if (alarm == null) {
                throw new IllegalArgumentException("Unable to locate alarm with ID '" + alarmId + "'");
            }
            String ackUser = ackUserValue == null ? this.m_securityContext.getUserPrincipal().getName() : ackUserValue;
            this.assertUserCredentials(ackUser);
            OnmsAcknowledgment acknowledgement = new OnmsAcknowledgment((Acknowledgeable)alarm, ackUser);
            acknowledgement.setAckAction(AckAction.UNSPECIFIED);
            if (ackValue != null) {
                if (Boolean.parseBoolean(ackValue)) {
                    acknowledgement.setAckAction(AckAction.ACKNOWLEDGE);
                } else {
                    acknowledgement.setAckAction(AckAction.UNACKNOWLEDGE);
                }
            } else if (escalateValue != null) {
                if (Boolean.parseBoolean(escalateValue)) {
                    acknowledgement.setAckAction(AckAction.ESCALATE);
                }
            } else if (clearValue != null) {
                if (Boolean.parseBoolean(clearValue)) {
                    acknowledgement.setAckAction(AckAction.CLEAR);
                }
            } else {
                throw new IllegalArgumentException("Must supply one of the 'ack', 'escalate', or 'clear' parameters, set to either 'true' or 'false'.");
            }
            this.m_ackDao.processAck(acknowledgement);
            Response response = Response.seeOther((URI)AlarmRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Transactional
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateAlarms(MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            Response response;
            String ackValue = formProperties.getFirst("ack");
            formProperties.remove("ack");
            String escalateValue = formProperties.getFirst("escalate");
            formProperties.remove("escalate");
            String clearValue = formProperties.getFirst("clear");
            formProperties.remove("clear");
            CriteriaBuilder builder = this.getCriteriaBuilder(formProperties, false);
            builder.distinct();
            builder.limit(Integer.valueOf(0));
            builder.offset(Integer.valueOf(0));
            String ackUser = formProperties.containsKey("ackUser") ? formProperties.getFirst("ackUser") : this.m_securityContext.getUserPrincipal().getName();
            formProperties.remove("ackUser");
            this.assertUserCredentials(ackUser);
            List alarms = this.m_alarmDao.findMatching(builder.toCriteria());
            for (OnmsAlarm alarm : alarms) {
                OnmsAcknowledgment acknowledgement = new OnmsAcknowledgment((Acknowledgeable)alarm, ackUser);
                acknowledgement.setAckAction(AckAction.UNSPECIFIED);
                if (ackValue != null) {
                    if (Boolean.parseBoolean(ackValue)) {
                        acknowledgement.setAckAction(AckAction.ACKNOWLEDGE);
                    } else {
                        acknowledgement.setAckAction(AckAction.UNACKNOWLEDGE);
                    }
                } else if (escalateValue != null) {
                    if (Boolean.parseBoolean(escalateValue)) {
                        acknowledgement.setAckAction(AckAction.ESCALATE);
                    }
                } else if (clearValue != null) {
                    if (Boolean.parseBoolean(clearValue)) {
                        acknowledgement.setAckAction(AckAction.CLEAR);
                    }
                } else {
                    throw new IllegalArgumentException("Must supply one of the 'ack', 'escalate', or 'clear' parameters, set to either 'true' or 'false'.");
                }
                this.m_ackDao.processAck(acknowledgement);
            }
            if (alarms.size() == 1) {
                response = Response.seeOther((URI)AlarmRestService.getRedirectUri(this.m_uriInfo, ((OnmsAlarm)alarms.get(0)).getId())).build();
                return response;
            }
            response = Response.seeOther((URI)AlarmRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void assertUserCredentials(String ackUser) {
        String currentUser = this.m_securityContext.getUserPrincipal().getName();
        if (!this.m_securityContext.isUserInRole("ROLE_ADMIN") && !ackUser.equals(currentUser)) {
            throw new IllegalArgumentException("You are logged in as non-admin user '" + currentUser + "', but you are trying to update an alarm as another user ('" + ackUser + "')!");
        }
    }
}

