/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.db;

import java.lang.reflect.UndeclaredThrowableException;
import org.opennms.web.map.MapsException;

public class DbElement
implements Cloneable {
    private int mapId;
    private int id;
    protected String type;
    private String label;
    private String icon;
    private String sysoid;
    private int x;
    private int y;

    public String getSysoid() {
        return this.sysoid;
    }

    public void setSysoid(String sysoid) {
        this.sysoid = sysoid;
    }

    protected DbElement() {
    }

    public DbElement(DbElement e) throws MapsException {
        this(e.mapId, e.id, e.type, e.label, e.sysoid, e.icon, e.x, e.y);
    }

    public DbElement(int mapId, int id, String type, String label, String sysoid, String iconName, int x, int y) throws MapsException {
        this.mapId = mapId;
        this.id = id;
        this.setType(type);
        this.label = label;
        this.sysoid = sysoid;
        this.setIcon(iconName);
        this.x = x;
        this.y = y;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String iconName) {
        this.icon = iconName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws MapsException {
        if (!(type.equals("M") || type.equals("N") || type.equals("H") || type.equals("W"))) {
            throw new MapsException("Cannot create an Element with type " + type);
        }
        this.type = type;
    }

    public int getMapId() {
        return this.mapId;
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public DbElement clone() {
        try {
            return (DbElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UndeclaredThrowableException(e, "CloneNotSupportedException thrown while calling super.clone(), which is odd since we implement the Cloneable interface");
        }
    }

    public boolean isMap() {
        return this.type.equals("M");
    }

    public boolean isNode() {
        return this.type.equals("N");
    }

    public boolean isHideMap() {
        return this.type.equals("W");
    }

    public boolean isHideNode() {
        return this.type.equals("H");
    }
}

