/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.logging.Logging;
import org.opennms.core.resource.db.DbConnectionFactory;
import org.opennms.core.resource.db.SimpleDbConnectionFactory;
import org.opennms.web.map.MapsException;
import org.opennms.web.map.db.DbElement;
import org.opennms.web.map.db.DbMap;
import org.opennms.web.map.db.LinkInfo;
import org.opennms.web.map.db.Manager;
import org.opennms.web.map.view.VElementInfo;
import org.opennms.web.map.view.VMapInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
extends Manager {
    private static final Logger LOG = LoggerFactory.getLogger(DBManager.class);
    private static final String mapTable = "map";
    private static final String elementTable = "element";
    private DbConnectionFactory m_factory = null;
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public DBManager() throws MapsException {
        Logging.withPrefix((String)mapTable, (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.debug("Instantiating DBManager (using Vault)");
            }
        });
    }

    public DBManager(final Map<String, String> params) throws MapsException {
        Logging.withPrefix((String)mapTable, (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.debug("Instantiating DBManager with params: {}", (Object)params);
            }
        });
        String url = params.get("url");
        String driver = params.get("driver");
        String user = params.get("user");
        String password = params.get("password");
        this.m_factory = new SimpleDbConnectionFactory();
        try {
            this.m_factory.init(url, driver, user, password);
        }
        catch (Throwable e) {
            throw new MapsException("Error while initializing dbconnection factory", e);
        }
    }

    Connection createConnection() throws MapsException {
        if (this.m_factory != null) {
            try {
                return this.m_factory.getConnection();
            }
            catch (SQLException e) {
                LOG.error("Exception while creating connection");
                throw new MapsException((Throwable)e);
            }
        }
        try {
            return DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException e) {
            LOG.error("Exception while creating connection");
            throw new MapsException((Throwable)e);
        }
    }

    void releaseConnection(Connection conn) throws MapsException {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (Throwable e) {
            LOG.error("Exception while releasing connection");
            throw new MapsException(e);
        }
    }

    protected void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            LOG.error("Error while closing statement", (Throwable)ex);
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.error("Error while closing result set", (Throwable)ex);
        }
    }

    public void finalize(Connection conn) throws MapsException {
        LOG.debug("finalizing...");
        try {
            this.releaseConnection(conn);
        }
        catch (Throwable e) {
            LOG.error("Exception while finalizing", e);
            throw new MapsException(e);
        }
    }

    private Connection startSession() throws MapsException {
        try {
            Connection conn = this.createConnection();
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(2);
            return conn;
        }
        catch (Throwable e) {
            LOG.error("error while starting session");
            throw new MapsException(e);
        }
    }

    private synchronized void endSession(Connection conn) throws MapsException {
        try {
            conn.commit();
            conn.setAutoCommit(true);
            this.releaseConnection(conn);
        }
        catch (Throwable e) {
            LOG.error("error while ending session");
            throw new MapsException(e);
        }
    }

    private void rollback(Connection conn) throws MapsException {
        try {
            conn.rollback();
        }
        catch (SQLException ex) {
            LOG.error("Error while rollback");
            throw new MapsException((Throwable)ex);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public synchronized int saveMap(DbMap m, Collection<DbElement> e) throws MapsException {
        LOG.debug("saving map...");
        Connection conn = this.startSession();
        String sqlGetCurrentTimestamp = "SELECT CURRENT_TIMESTAMP";
        String sqlGetMapNxtId = "SELECT nextval('mapnxtid')";
        String sqlInsertQuery = "INSERT INTO map (mapid, mapname, mapbackground, mapowner, mapcreatetime, mapaccess, userlastmodifies, lastmodifiedtime, mapscale, mapxoffset, mapyoffset, maptype, mapwidth, mapheight) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String sqlUpdateQuery = "UPDATE map SET mapname = ?, mapbackground = ?, mapowner = ?, mapaccess = ?, userlastmodifies = ?, lastmodifiedtime = ?, mapscale = ?, mapxoffset = ?, mapyoffset = ?, maptype = ? , mapwidth = ?, mapheight = ? WHERE mapid = ?";
        Timestamp currentTimestamp = null;
        int nxtid = 0;
        int count = -1;
        PreparedStatement statement = null;
        Statement timeStatement = null;
        ResultSet rs = null;
        try {
            timeStatement = conn.createStatement();
            rs = timeStatement.executeQuery("SELECT CURRENT_TIMESTAMP");
            if (rs.next()) {
                currentTimestamp = rs.getTimestamp(1);
                if (m.isNew()) {
                    Statement stmtID = conn.createStatement();
                    ResultSet rsStmt = stmtID.executeQuery("SELECT nextval('mapnxtid')");
                    if (rsStmt.next()) {
                        nxtid = rsStmt.getInt(1);
                    }
                    rsStmt.close();
                    stmtID.close();
                    statement = conn.prepareStatement("INSERT INTO map (mapid, mapname, mapbackground, mapowner, mapcreatetime, mapaccess, userlastmodifies, lastmodifiedtime, mapscale, mapxoffset, mapyoffset, maptype, mapwidth, mapheight) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    statement.setInt(1, nxtid);
                    statement.setString(2, m.getName());
                    statement.setString(3, m.getBackground());
                    statement.setString(4, m.getOwner());
                    statement.setTimestamp(5, currentTimestamp);
                    statement.setString(6, m.getAccessMode());
                    statement.setString(7, m.getUserLastModifies());
                    statement.setTimestamp(8, currentTimestamp);
                    statement.setDouble(9, m.getScale());
                    statement.setInt(10, m.getOffsetX());
                    statement.setInt(11, m.getOffsetY());
                    statement.setString(12, m.getType());
                    statement.setInt(13, m.getWidth());
                    statement.setInt(14, m.getHeight());
                } else {
                    statement = conn.prepareStatement("UPDATE map SET mapname = ?, mapbackground = ?, mapowner = ?, mapaccess = ?, userlastmodifies = ?, lastmodifiedtime = ?, mapscale = ?, mapxoffset = ?, mapyoffset = ?, maptype = ? , mapwidth = ?, mapheight = ? WHERE mapid = ?");
                    statement.setString(1, m.getName());
                    statement.setString(2, m.getBackground());
                    statement.setString(3, m.getOwner());
                    statement.setString(4, m.getAccessMode());
                    statement.setString(5, m.getUserLastModifies());
                    statement.setTimestamp(6, currentTimestamp);
                    statement.setDouble(7, m.getScale());
                    statement.setInt(8, m.getOffsetX());
                    statement.setInt(9, m.getOffsetY());
                    statement.setString(10, m.getType());
                    statement.setInt(11, m.getWidth());
                    statement.setInt(12, m.getHeight());
                    statement.setInt(13, m.getId());
                }
                count = statement.executeUpdate();
                if (count == 0) {
                    LOG.warn("Called saveMap() on deleted map");
                    throw new MapsException("Called saveMap() on deleted map");
                }
                if (m.isNew()) {
                    for (DbElement dbe : e) {
                        dbe.setMapId(nxtid);
                        this.saveElementInSession(dbe, conn);
                    }
                } else {
                    this.deleteElementsOfMapInSession(m.getId(), conn);
                    for (DbElement dbe : e) {
                        this.saveElementInSession(dbe, conn);
                    }
                }
            }
            this.closeResultSet(rs);
            this.closeStatement(timeStatement);
            this.closeStatement(statement);
        }
        catch (SQLException ex) {
            try {
                LOG.error("Error while saving map");
                this.rollback(conn);
                throw new MapsException("Error while saving map " + m.getId(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(timeStatement);
                this.closeStatement(statement);
                this.endSession(conn);
                throw throwable;
            }
        }
        this.endSession(conn);
        if (m.isNew()) {
            return nxtid;
        }
        return m.getId();
    }

    private synchronized void saveElementInSession(DbElement e, Connection conn) throws MapsException {
        LOG.debug("saving element: {}{}", (Object)e.getId(), (Object)e.getType());
        String sqlSelectQuery = "SELECT COUNT(*) FROM element WHERE elementid = ? AND MAPID = ? AND elementtype = ?";
        String sqlInsertQuery = "INSERT INTO element (mapid, elementid, elementtype, elementlabel, elementicon, elementx, elementy) VALUES (?, ?, ?, ?, ?, ?, ?)";
        String sqlUpdateQuery = "UPDATE element SET mapid = ?, elementid = ?, elementtype = ?, elementlabel = ?, elementicon = ?, elementx = ?, elementy = ? WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("SELECT COUNT(*) FROM element WHERE elementid = ? AND MAPID = ? AND elementtype = ?");
            statement.setInt(1, e.getId());
            statement.setInt(2, e.getMapId());
            statement.setString(3, e.getType());
            rs = statement.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                statement.close();
                if (count == 0) {
                    statement = conn.prepareStatement("INSERT INTO element (mapid, elementid, elementtype, elementlabel, elementicon, elementx, elementy) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                } else {
                    statement = conn.prepareStatement("UPDATE element SET mapid = ?, elementid = ?, elementtype = ?, elementlabel = ?, elementicon = ?, elementx = ?, elementy = ? WHERE elementid = ? AND mapid = ? AND elementtype = ?");
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                    statement.setInt(8, e.getId());
                    statement.setInt(9, e.getMapId());
                    statement.setString(10, e.getType());
                }
                count = statement.executeUpdate();
            }
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (SQLException ex) {
            try {
                LOG.error("error while saving element");
                throw new MapsException((Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                throw throwable;
            }
        }
    }

    public synchronized void saveElement(DbElement e) throws MapsException {
        LOG.debug("saving element");
        Connection conn = this.startSession();
        String sqlSelectQuery = "SELECT COUNT(*) FROM element WHERE elementid = ? AND MAPID = ? AND elementtype = ?";
        String sqlInsertQuery = "INSERT INTO element (mapid, elementid, elementtype, elementlabel, elementicon, elementx, elementy) VALUES (?, ?, ?, ?, ?, ?, ?)";
        String sqlUpdateQuery = "UPDATE element SET mapid = ?, elementid = ?, elementtype = ?, elementlabel = ?, elementicon = ?, elementx = ?, elementy = ? WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("SELECT COUNT(*) FROM element WHERE elementid = ? AND MAPID = ? AND elementtype = ?");
            statement.setInt(1, e.getId());
            statement.setInt(2, e.getMapId());
            statement.setString(3, e.getType());
            rs = statement.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                statement.close();
                if (count == 0) {
                    statement = conn.prepareStatement("INSERT INTO element (mapid, elementid, elementtype, elementlabel, elementicon, elementx, elementy) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                } else {
                    statement = conn.prepareStatement("UPDATE element SET mapid = ?, elementid = ?, elementtype = ?, elementlabel = ?, elementicon = ?, elementx = ?, elementy = ? WHERE elementid = ? AND mapid = ? AND elementtype = ?");
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                    statement.setInt(8, e.getId());
                    statement.setInt(9, e.getMapId());
                    statement.setString(10, e.getType());
                }
                count = statement.executeUpdate();
            }
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (SQLException ex) {
            try {
                LOG.error("error while saving element");
                this.rollback(conn);
                throw new MapsException((Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.endSession(conn);
                throw throwable;
            }
        }
        this.endSession(conn);
    }

    public synchronized void deleteElements(DbElement[] elems) throws MapsException {
        LOG.debug("deleting elements...");
        Connection conn = this.startSession();
        try {
            if (elems != null) {
                for (int i = 0; i < elems.length; ++i) {
                    this.deleteElementInSession(elems[i].getId(), elems[i].getMapId(), elems[i].getType());
                }
            }
        }
        catch (MapsException e) {
            LOG.error("Error while deleting elements");
            this.rollback(conn);
            throw e;
        }
        finally {
            this.endSession(conn);
        }
    }

    public synchronized void deleteElement(DbElement e) throws MapsException {
        LOG.debug("deleting element...");
        if (e != null) {
            this.deleteElement(e.getId(), e.getMapId(), e.getType());
        }
    }

    private synchronized void deleteElementInSession(int id, int mapid, String type) throws MapsException {
        LOG.debug("deleting element...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM element WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("DELETE FROM element WHERE elementid = ? AND mapid = ? AND elementtype = ?");
            statement.setInt(1, id);
            statement.setInt(2, mapid);
            statement.setString(3, type);
            statement.execute();
        }
        catch (SQLException e) {
            LOG.error("error while deleting element...");
            this.rollback(conn);
            throw new MapsException((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
            this.endSession(conn);
        }
    }

    public synchronized void deleteElement(int id, int mapid, String type) throws MapsException {
        LOG.debug("deleting element...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM element WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("DELETE FROM element WHERE elementid = ? AND mapid = ? AND elementtype = ?");
            statement.setInt(1, id);
            statement.setInt(2, mapid);
            statement.setString(3, type);
            statement.execute();
        }
        catch (SQLException e) {
            LOG.error("error while deleting element...", (Throwable)e);
            this.rollback(conn);
            throw new MapsException((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
            this.endSession(conn);
        }
    }

    private synchronized void deleteElementsOfMapInSession(int id, Connection conn) throws MapsException {
        LOG.debug("deleting elements of map...");
        String sqlDelete = "DELETE FROM element WHERE mapid = ?";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("DELETE FROM element WHERE mapid = ?");
            statement.setInt(1, id);
            statement.execute();
        }
        catch (SQLException e) {
            LOG.error("Error while deleting elements of map {}", (Object)id);
            this.rollback(conn);
            throw new MapsException((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
        }
    }

    @Override
    public synchronized int deleteMap(int id) throws MapsException {
        LOG.debug("deleting map...");
        Connection conn = this.startSession();
        String sqlDeleteMap = "DELETE FROM map WHERE mapid = ? AND maptype != ? ";
        int countDelete = 0;
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("DELETE FROM map WHERE mapid = ? AND maptype != ? ");
            statement.setInt(1, id);
            statement.setString(2, "A");
            countDelete = statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error("error while deleting map {}", (Object)id);
            this.rollback(conn);
            throw new MapsException((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
            this.endSession(conn);
        }
        return countDelete;
    }

    @Override
    public synchronized void deleteNodeTypeElementsFromAllMaps() throws MapsException {
        LOG.debug("deleting all node elements...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM element WHERE elementtype = ?";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("DELETE FROM element WHERE elementtype = ?");
            statement.setString(1, "N");
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            LOG.error("error while deleting all node elements");
            this.rollback(conn);
            throw new MapsException((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
            this.endSession(conn);
        }
    }

    @Override
    public synchronized void deleteMapTypeElementsFromAllMaps() throws MapsException {
        LOG.debug("deleting all map elements...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM element WHERE elementtype = ?";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("DELETE FROM element WHERE elementtype = ?");
            statement.setString(1, "M");
            statement.execute();
        }
        catch (SQLException e) {
            LOG.error("error while deleting all map elements");
            this.rollback(conn);
            throw new MapsException((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
            this.endSession(conn);
        }
    }

    @Override
    public DbElement getElement(int id, int mapId, String type) throws MapsException {
        DbElement dbElement;
        Connection conn = this.createConnection();
        String sqlQuery = "SELECT * FROM element WHERE elementid = ? AND mapid = ? and elementtype = ?";
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("SELECT * FROM element WHERE elementid = ? AND mapid = ? and elementtype = ?");
            statement.setInt(1, id);
            statement.setInt(2, mapId);
            statement.setString(3, type);
            rs = statement.executeQuery();
            dbElement = this.rs2Element(rs);
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting element with elementid={} and mapid={}", (Object)id, (Object)mapId);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbElement;
    }

    @Override
    public DbElement newElement(int id, int mapId, String type) throws MapsException {
        DbElement e = new DbElement(mapId, id, type, null, null, null, 0, 0);
        e = this.completeElement(e);
        LOG.debug("Creating new VElement mapId:{} id:{} type:{} label:{} iconname:{} x:{} y:{}", new Object[]{mapId, id, type, e.getLabel(), e.getIcon(), 0, 0});
        return e;
    }

    private DbElement completeElement(DbElement e) throws MapsException {
        Connection conn = this.createConnection();
        String sqlQuery = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            sqlQuery = e.getType().equals("M") ? "SELECT mapname FROM map WHERE mapId = ?" : "SELECT nodelabel,nodesysoid FROM node WHERE nodeid = ?";
            statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, e.getId());
            rs = statement.executeQuery();
            if (rs.next()) {
                e.setLabel(this.getLabel(rs.getString(1)));
                if (e.getType().equals("N") && rs.getString(2) != null) {
                    LOG.debug("DBManager: sysoid = {}", (Object)rs.getString(2));
                    e.setSysoid(rs.getString(2));
                }
            }
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e1) {
            try {
                LOG.error("Error while completing element ({}) with label and icon ", (Object)e.getId(), (Object)e1);
                throw new MapsException(e1);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return e;
    }

    @Override
    public DbElement[] getAllElements() throws MapsException {
        DbElement[] dbElementArray;
        Vector<DbElement> elements;
        ResultSet rs;
        Statement statement;
        Connection conn;
        block5: {
            conn = this.createConnection();
            statement = null;
            rs = null;
            String sqlQuery = "SELECT * FROM element";
            statement = conn.createStatement();
            rs = statement.executeQuery("SELECT * FROM element");
            elements = this.rs2ElementVector(rs);
            rs.close();
            statement.close();
            if (elements != null) break block5;
            DbElement[] dbElementArray2 = new DbElement[]{};
            this.closeResultSet(rs);
            this.closeStatement(statement);
            this.releaseConnection(conn);
            return dbElementArray2;
        }
        try {
            DbElement[] el = new DbElement[elements.size()];
            dbElementArray = el = elements.toArray(el);
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all elements");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbElementArray;
    }

    @Override
    public DbElement[] getElementsOfMap(int mapid) throws MapsException {
        DbElement[] dbElementArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM element WHERE mapid = ?";
            statement = conn.prepareStatement("SELECT * FROM element WHERE mapid = ?");
            statement.setInt(1, mapid);
            rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = null;
            if (elements != null) {
                el = new DbElement[elements.size()];
                el = elements.toArray(el);
            }
            dbElementArray = el;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting elements of map with mapid={}", (Object)mapid);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbElementArray;
    }

    @Override
    public DbElement[] getNodeElementsOfMap(int mapid) throws MapsException {
        DbElement[] dbElementArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM element WHERE mapid = ? AND elementtype = 'N' ";
            statement = conn.prepareStatement("SELECT * FROM element WHERE mapid = ? AND elementtype = 'N' ");
            statement.setInt(1, mapid);
            rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = null;
            if (elements != null) {
                el = new DbElement[elements.size()];
                el = elements.toArray(el);
            }
            dbElementArray = el;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting element node of map with mapid {}", (Object)mapid);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbElementArray;
    }

    @Override
    public DbElement[] getMapElementsOfMap(int mapid) throws MapsException {
        DbElement[] dbElementArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM element WHERE mapid = ? AND elementtype = 'M' ";
            statement = conn.prepareStatement("SELECT * FROM element WHERE mapid = ? AND elementtype = 'M' ");
            statement.setInt(1, mapid);
            rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = null;
            if (elements != null) {
                el = new DbElement[elements.size()];
                el = elements.toArray(el);
            }
            dbElementArray = el;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting map element of map with mapid {}", (Object)mapid);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbElementArray;
    }

    @Override
    public DbElement[] getElementsLike(String elementLabel) throws MapsException {
        DbElement[] dbElementArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM element WHERE elementlabel LIKE ?";
            statement = conn.prepareStatement("SELECT * FROM element WHERE elementlabel LIKE ?");
            elementLabel = "%" + elementLabel + "%";
            statement.setString(1, elementLabel);
            rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = new DbElement[elements.size()];
            dbElementArray = el = elements.toArray(el);
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting elements by label like {}", (Object)elementLabel);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbElementArray;
    }

    @Override
    public Map<Integer, Set<Integer>> getMapsStructure() throws MapsException {
        HashMap<Integer, Set<Integer>> hashMap;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            HashMap<Integer, Set<Integer>> maps = new HashMap<Integer, Set<Integer>>();
            String sqlQuery = "select elementid,mapid from element where elementtype=?";
            statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, "M");
            rs = statement.executeQuery();
            while (rs.next()) {
                Integer parentId = rs.getInt("mapid");
                Integer childId = rs.getInt("elementid");
                HashSet<Integer> childs = (HashSet<Integer>)maps.get(parentId);
                if (childs == null) {
                    childs = new HashSet<Integer>();
                }
                if (!childs.contains(childId)) {
                    childs.add(childId);
                }
                maps.put(parentId, childs);
            }
            hashMap = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting maps parent-child structure");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return hashMap;
    }

    @Override
    public int countMaps(int mapId) throws MapsException {
        int n;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT COUNT(*) FROM map WHERE mapid = ?";
            statement = conn.prepareStatement("SELECT COUNT(*) FROM map WHERE mapid = ?");
            statement.setInt(1, mapId);
            rs = statement.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            n = count;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while counting maps");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return n;
    }

    @Override
    public DbMap getMap(int id) throws MapsException {
        DbMap dbMap;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM map WHERE mapId = ?";
            statement = conn.prepareStatement("SELECT * FROM map WHERE mapId = ?");
            statement.setInt(1, id);
            rs = statement.executeQuery();
            dbMap = this.rs2Map(rs);
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting map with mapid={}", (Object)id);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbMap;
    }

    @Override
    public DbMap[] getMaps(String mapname, String maptype) throws MapsException {
        DbMap[] dbMapArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM map WHERE mapName= ? AND maptype = ? ";
            statement = conn.prepareStatement("SELECT * FROM map WHERE mapName= ? AND maptype = ? ");
            statement.setString(1, mapname);
            statement.setString(2, maptype);
            rs = statement.executeQuery();
            Vector<DbMap> maps = this.rs2MapVector(rs);
            DbMap[] el = null;
            if (maps != null) {
                el = new DbMap[maps.size()];
                el = maps.toArray(el);
            }
            dbMapArray = el;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting maps with name={} and type={}", (Object)mapname, (Object)maptype);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbMapArray;
    }

    @Override
    public DbMap[] getAllMaps() throws MapsException {
        DbMap[] dbMapArray;
        Connection conn = this.createConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM map";
            statement = conn.createStatement();
            rs = statement.executeQuery("SELECT * FROM map");
            Vector<DbMap> maps = this.rs2MapVector(rs);
            DbMap[] el = null;
            if (maps != null) {
                el = new DbMap[maps.size()];
                el = maps.toArray(el);
            }
            dbMapArray = el;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all Maps");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbMapArray;
    }

    @Override
    public DbMap[] getMapsLike(String mapLabel) throws MapsException {
        DbMap[] dbMapArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM map WHERE mapname LIKE ?";
            statement = conn.prepareStatement("SELECT * FROM map WHERE mapname LIKE ?");
            mapLabel = "%" + mapLabel + "%";
            statement.setString(1, mapLabel);
            rs = statement.executeQuery();
            Vector<DbMap> mapVector = this.rs2MapVector(rs);
            DbMap[] maps = null;
            if (mapVector != null) {
                maps = new DbMap[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            dbMapArray = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting maps by label like {}", (Object)mapLabel);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbMapArray;
    }

    @Override
    public DbMap[] getMapsByName(String mapLabel) throws MapsException {
        DbMap[] dbMapArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT * FROM map WHERE mapname = ?";
            statement = conn.prepareStatement("SELECT * FROM map WHERE mapname = ?");
            statement.setString(1, mapLabel);
            rs = statement.executeQuery();
            Vector<DbMap> mapVector = this.rs2MapVector(rs);
            DbMap[] maps = null;
            if (mapVector != null) {
                maps = new DbMap[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            dbMapArray = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting elements with label {}", (Object)mapLabel);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbMapArray;
    }

    @Override
    public DbMap[] getContainerMaps(int id, String type) throws MapsException {
        DbMap[] dbMapArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT map.* FROM map INNER JOIN element ON map.mapid = element.mapid WHERE elementid = ? AND elementtype = ?";
            statement = conn.prepareStatement("SELECT map.* FROM map INNER JOIN element ON map.mapid = element.mapid WHERE elementid = ? AND elementtype = ?");
            statement.setInt(1, id);
            statement.setString(2, type);
            rs = statement.executeQuery();
            Vector<DbMap> el = this.rs2MapVector(rs);
            DbMap[] maps = new DbMap[el.size()];
            dbMapArray = maps = el.toArray(maps);
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting container maps of element with id/type {}/{}", (Object)id, (Object)type);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return dbMapArray;
    }

    @Override
    public VMapInfo[] getAllMapMenus() throws MapsException {
        VMapInfo[] vMapInfoArray;
        Connection conn = this.createConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM map order by mapname";
            statement = conn.createStatement();
            rs = statement.executeQuery("SELECT mapid,mapname,mapowner FROM map order by mapname");
            Vector<VMapInfo> maps = this.rs2MapMenuVector(rs);
            VMapInfo[] el = null;
            if (maps != null) {
                el = new VMapInfo[maps.size()];
                el = maps.toArray(el);
            }
            vMapInfoArray = el;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all map-menu");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vMapInfoArray;
    }

    @Override
    public VMapInfo getMapMenu(int mapId) throws MapsException {
        VMapInfo vMapInfo;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM map where mapId= ?";
            statement = conn.prepareStatement("SELECT mapid,mapname,mapowner FROM map where mapId= ?");
            statement.setInt(1, mapId);
            rs = statement.executeQuery();
            vMapInfo = this.rs2MapMenu(rs);
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting map-menu for mapid {}", (Object)mapId);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vMapInfo;
    }

    @Override
    public VMapInfo[] getMapsMenuByName(String mapLabel) throws MapsException {
        VMapInfo[] vMapInfoArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM map WHERE upper( mapname ) = upper( ? )";
            statement = conn.prepareStatement("SELECT mapid,mapname,mapowner FROM map WHERE upper( mapname ) = upper( ? )");
            statement.setString(1, mapLabel);
            rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            vMapInfoArray = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all map-menu for map named {}", (Object)mapLabel);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vMapInfoArray;
    }

    @Override
    public VMapInfo[] getMapsMenuByOwner(String owner) throws MapsException {
        VMapInfo[] vMapInfoArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM map WHERE upper( mapowner ) = upper( ? ) and upper( mapaccess ) = upper( ? )";
            statement = conn.prepareStatement("SELECT mapid,mapname,mapowner FROM map WHERE upper( mapowner ) = upper( ? ) and upper( mapaccess ) = upper( ? )");
            statement.setString(1, owner);
            statement.setString(2, "RWRO");
            rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            vMapInfoArray = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all map-menu for owner {}", (Object)owner);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vMapInfoArray;
    }

    @Override
    public VMapInfo[] getMapsMenuByGroup(String group) throws MapsException {
        VMapInfo[] vMapInfoArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM map WHERE upper( mapgroup ) = upper( ? ) and upper( mapaccess ) = upper( ? )";
            statement = conn.prepareStatement("SELECT mapid,mapname,mapowner FROM map WHERE upper( mapgroup ) = upper( ? ) and upper( mapaccess ) = upper( ? )");
            statement.setString(1, group);
            statement.setString(2, "RWRO");
            rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            vMapInfoArray = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all map-menu for group {}", (Object)group);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vMapInfoArray;
    }

    @Override
    public VMapInfo[] getMapsMenuByOther() throws MapsException {
        VMapInfo[] vMapInfoArray;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM map WHERE upper( mapaccess ) = upper( ? ) or upper( mapaccess ) = upper( ? )";
            statement = conn.prepareStatement("SELECT mapid,mapname,mapowner FROM map WHERE upper( mapaccess ) = upper( ? ) or upper( mapaccess ) = upper( ? )");
            statement.setString(1, "RW");
            statement.setString(2, "RO");
            rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            vMapInfoArray = maps;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting other map for access");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vMapInfoArray;
    }

    @Override
    public boolean isElementInMap(int elementId, int mapId, String type) throws MapsException {
        try {
            DbElement element = null;
            element = this.getElement(elementId, mapId, type);
            return element != null;
        }
        catch (Throwable e) {
            throw new MapsException(e);
        }
    }

    @Override
    public Vector<VElementInfo> getAllElementInfo() throws MapsException {
        Vector<VElementInfo> vector;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT  n.nodeid,n.nodelabel,i.ipaddr FROM node n left join ipinterface i on n.nodeid=i.nodeid WHERE n.nodetype!='D' and (i.issnmpprimary='P' or i.issnmpprimary='N') order by nodeid,issnmpprimary desc";
            statement = conn.prepareStatement("SELECT  n.nodeid,n.nodelabel,i.ipaddr FROM node n left join ipinterface i on n.nodeid=i.nodeid WHERE n.nodetype!='D' and (i.issnmpprimary='P' or i.issnmpprimary='N') order by nodeid,issnmpprimary desc");
            rs = statement.executeQuery();
            Vector<VElementInfo> elements = new Vector<VElementInfo>();
            int previousNodeid = -1;
            while (rs.next()) {
                int curnodeid = rs.getInt("nodeid");
                if (curnodeid != previousNodeid) {
                    VElementInfo ei = new VElementInfo(curnodeid, rs.getString("ipaddr"), rs.getString("nodelabel"));
                    elements.add(ei);
                }
                previousNodeid = curnodeid;
            }
            vector = elements;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting all element infos", e);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vector;
    }

    @Override
    public List<VElementInfo> getAlarmedElements() throws MapsException {
        ArrayList<VElementInfo> arrayList;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "select nodeid, eventuei,severity from alarms where nodeid is not null and severity > 3 order by nodeid, lasteventtime desc";
            statement = conn.prepareStatement("select nodeid, eventuei,severity from alarms where nodeid is not null and severity > 3 order by nodeid, lasteventtime desc");
            rs = statement.executeQuery();
            ArrayList<VElementInfo> elems = new ArrayList<VElementInfo>();
            while (rs.next()) {
                VElementInfo einfo = new VElementInfo(rs.getInt(1), rs.getString(2), rs.getInt(3));
                elems.add(einfo);
            }
            arrayList = elems;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting outaged elements");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return arrayList;
    }

    @Override
    public Map<Integer, Double> getAvails(DbElement[] mapElements) throws MapsException {
        Map<Integer, Double> availsMap = null;
        LOG.debug("avail Enabled");
        LOG.debug("getting all nodeids of map (and submaps)");
        HashSet<Integer> nodeIds = new HashSet<Integer>();
        if (mapElements != null) {
            for (int i = 0; i < mapElements.length; ++i) {
                if (mapElements[i].isNode()) {
                    nodeIds.add(mapElements[i].getId());
                    continue;
                }
                nodeIds.addAll(this.getNodeidsOnElement(mapElements[i]));
            }
        }
        LOG.debug("all nodeids obtained");
        LOG.debug("Getting avails for nodes of map ({} nodes)", (Object)nodeIds.size());
        availsMap = this.getNodeAvailability(nodeIds);
        LOG.debug("Avails obtained");
        return availsMap;
    }

    private Map<Integer, Double> getNodeAvailability(Set<Integer> nodeIds) throws MapsException {
        GregorianCalendar cal = new GregorianCalendar();
        Date end = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date start = cal.getTime();
        if (nodeIds == null) {
            throw new IllegalArgumentException("Cannot take nodeIds null.");
        }
        if (start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        int nodeid = 0;
        TreeMap<Integer, Double> retMap = new TreeMap<Integer, Double>();
        if (nodeIds.size() > 0) {
            Connection conn = this.createConnection();
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer sb = new StringBuffer("select nodeid, getManagePercentAvailNodeWindow(nodeid, ?, ?)  from node where nodeid in (");
                Iterator<Integer> it = nodeIds.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
                statement = conn.prepareStatement(sb.toString());
                statement.setTimestamp(1, new Timestamp(end.getTime()));
                statement.setTimestamp(2, new Timestamp(start.getTime()));
                rs = statement.executeQuery();
                while (rs.next()) {
                    nodeid = rs.getInt(1);
                    avail = rs.getDouble(2);
                    retMap.put(nodeid, avail);
                }
                this.closeResultSet(rs);
                this.closeStatement(statement);
            }
            catch (Throwable e) {
                try {
                    throw new MapsException(e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(statement);
                    this.releaseConnection(conn);
                    throw throwable;
                }
            }
            this.releaseConnection(conn);
        }
        return retMap;
    }

    String getMapName(int id) throws MapsException {
        String string;
        Connection conn = this.createConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT mapname FROM map WHERE mapId = ?";
            statement = conn.prepareStatement("SELECT mapname FROM map WHERE mapId = ?");
            statement.setInt(1, id);
            rs = statement.executeQuery();
            String label = null;
            if (rs.next()) {
                label = rs.getString(1);
            }
            string = label;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting name of map with mapid {}", (Object)id);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return string;
    }

    @Override
    public Vector<Integer> getDeletedNodes() throws MapsException {
        Vector<Integer> vector;
        Connection conn = this.createConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "SELECT nodeid  FROM node where nodetype='D'";
            statement = conn.createStatement();
            rs = statement.executeQuery("SELECT nodeid  FROM node where nodetype='D'");
            Vector<Integer> elements = new Vector<Integer>();
            while (rs.next()) {
                int nId = rs.getInt(1);
                elements.add(nId);
            }
            vector = elements;
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting deleted nodes");
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return vector;
    }

    @Override
    public Set<Integer> getNodeidsOnElement(DbElement elem) throws MapsException {
        HashSet<Integer> elementNodeIds = new HashSet<Integer>();
        if (elem.isNode()) {
            elementNodeIds.add(elem.getId());
        } else if (elem.isMap()) {
            DbElement[] elemMapElems;
            int curMapId = elem.getId();
            DbElement[] elemNodeElems = this.getNodeElementsOfMap(curMapId);
            if (elemNodeElems != null && elemNodeElems.length > 0) {
                for (int i = 0; i < elemNodeElems.length; ++i) {
                    elementNodeIds.add(elemNodeElems[i].getId());
                }
            }
            if ((elemMapElems = this.getMapElementsOfMap(curMapId)) != null && elemMapElems.length > 0) {
                for (int i = 0; i < elemMapElems.length; ++i) {
                    elementNodeIds.addAll(this.getNodeidsOnElement(elemMapElems[i]));
                }
            }
        }
        return elementNodeIds;
    }

    private Vector<DbMap> rs2MapVector(ResultSet rs) throws SQLException {
        Vector<DbMap> mapVec = null;
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                mapVec = new Vector<DbMap>();
                firstTime = false;
            }
            DbMap currMap = new DbMap();
            currMap.setAccessMode(rs.getString("mapAccess"));
            currMap.setBackground(rs.getString("mapBackGround"));
            currMap.setId(rs.getInt("mapId"));
            currMap.setName(rs.getString("mapName"));
            currMap.setOffsetX(rs.getInt("mapXOffset"));
            currMap.setOffsetY(rs.getInt("mapYOffset"));
            currMap.setOwner(rs.getString("mapOwner"));
            currMap.setScale(rs.getFloat("mapScale"));
            currMap.setType(rs.getString("mapType"));
            currMap.setWidth(rs.getInt("mapwidth"));
            currMap.setHeight(rs.getInt("mapheight"));
            currMap.setUserLastModifies(rs.getString("userLastModifies"));
            currMap.setCreateTime(rs.getTimestamp("mapCreateTime"));
            currMap.setLastModifiedTime(rs.getTimestamp("lastmodifiedtime"));
            currMap.setAsNew(false);
            mapVec.add(currMap);
        }
        return mapVec;
    }

    private Vector<VMapInfo> rs2MapMenuVector(ResultSet rs) throws SQLException {
        Vector<VMapInfo> mapVec = null;
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                mapVec = new Vector<VMapInfo>();
                firstTime = false;
            }
            VMapInfo currMap = new VMapInfo(rs.getInt("mapId"), rs.getString("mapName"), rs.getString("mapOwner"));
            mapVec.add(currMap);
        }
        return mapVec;
    }

    private VMapInfo rs2MapMenu(ResultSet rs) throws SQLException {
        VMapInfo map = null;
        if (rs.next()) {
            map = new VMapInfo(rs.getInt("mapId"), rs.getString("mapName"), rs.getString("mapOwner"));
        }
        return map;
    }

    private DbMap rs2Map(ResultSet rs) throws SQLException {
        DbMap map = null;
        if (rs.next()) {
            map = new DbMap();
            map.setAccessMode(rs.getString("mapAccess"));
            map.setBackground(rs.getString("mapBackGround"));
            map.setId(rs.getInt("mapId"));
            map.setName(rs.getString("mapName"));
            map.setOffsetX(rs.getInt("mapXOffset"));
            map.setOffsetY(rs.getInt("mapYOffset"));
            map.setOwner(rs.getString("mapOwner"));
            map.setGroup(rs.getString("mapGroup"));
            map.setScale(rs.getFloat("mapScale"));
            map.setType(rs.getString("mapType"));
            map.setWidth(rs.getInt("mapwidth"));
            map.setHeight(rs.getInt("mapheight"));
            map.setUserLastModifies(rs.getString("userLastModifies"));
            map.setCreateTime(rs.getTimestamp("mapCreateTime"));
            map.setLastModifiedTime(rs.getTimestamp("lastmodifiedtime"));
            map.setAsNew(false);
        }
        return map;
    }

    private DbElement rs2Element(ResultSet rs) throws SQLException, MapsException {
        DbElement element = null;
        if (rs.next()) {
            element = new DbElement();
            element.setMapId(rs.getInt("mapId"));
            element.setId(rs.getInt("elementId"));
            element.setType(rs.getString("elementType"));
            element.setLabel(rs.getString("elementLabel"));
            element.setIcon(rs.getString("elementIcon"));
            element.setX(rs.getInt("elementX"));
            element.setY(rs.getInt("elementY"));
        }
        return element;
    }

    private Vector<DbElement> rs2ElementVector(ResultSet rs) throws SQLException, MapsException {
        Vector<DbElement> vecElem = null;
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                vecElem = new Vector<DbElement>();
                firstTime = false;
            }
            DbElement currElem = new DbElement();
            currElem.setMapId(rs.getInt("mapId"));
            currElem.setId(rs.getInt("elementId"));
            currElem.setType(rs.getString("elementType"));
            currElem.setLabel(rs.getString("elementLabel"));
            currElem.setIcon(rs.getString("elementIcon"));
            currElem.setX(rs.getInt("elementX"));
            currElem.setY(rs.getInt("elementY"));
            vecElem.add(currElem);
        }
        return vecElem;
    }

    @Override
    public Set<LinkInfo> getLinksOnElements(Set<Integer> allnodes) throws MapsException {
        ResultSet rs;
        Statement statement;
        Connection conn;
        HashSet<LinkInfo> nodes;
        block38: {
            LOG.debug("getLinksOnElements {}", allnodes);
            nodes = null;
            conn = this.createConnection();
            statement = null;
            rs = null;
            nodes = new HashSet<LinkInfo>();
            if (allnodes != null && allnodes.size() != 0) break block38;
            HashSet<LinkInfo> hashSet = nodes;
            this.closeResultSet(rs);
            this.closeStatement(statement);
            this.releaseConnection(conn);
            return hashSet;
        }
        try {
            LinkInfo link;
            Object element;
            int snmpifadminstatus;
            int snmpifoperstatus;
            long snmpifspeed;
            int snmpiftype;
            String status;
            int linktypeid;
            int parentifindex;
            int nodeparentid;
            int ifindex;
            int nodeid;
            int id;
            String nodelist = "";
            Iterator<Integer> ite = allnodes.iterator();
            while (ite.hasNext()) {
                nodelist = nodelist + ite.next();
                if (!ite.hasNext()) continue;
                nodelist = nodelist + ",";
            }
            statement = conn.createStatement();
            String sql = "SELECT datalinkinterface.id, datalinkinterface.nodeid, ifindex,nodeparentid, parentifindex, status, linktypeid,snmpiftype,snmpifspeed,snmpifoperstatus,snmpifadminstatus FROM datalinkinterface left join snmpinterface on nodeparentid = snmpinterface.nodeid WHERE (datalinkinterface.nodeid IN (" + nodelist + ")" + " AND nodeparentid in (" + nodelist + ")) " + "AND status != 'D' and datalinkinterface.parentifindex = snmpinterface.snmpifindex";
            LOG.debug("getLinksOnElements: executing query:\n {}", (Object)sql);
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                id = -1;
                nodeid = -1;
                ifindex = -1;
                nodeparentid = -1;
                parentifindex = -1;
                linktypeid = -1;
                status = "U";
                snmpiftype = -1;
                snmpifspeed = -1L;
                snmpifoperstatus = -1;
                snmpifadminstatus = -1;
                element = rs.getInt("id");
                if (element != null) {
                    id = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("nodeid"))) != null) {
                    nodeid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("ifindex"))) != null) {
                    ifindex = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("nodeparentid"))) != null) {
                    nodeparentid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("parentifindex"))) != null) {
                    parentifindex = (Integer)element;
                }
                if ((element = new String(rs.getString("status"))) != null) {
                    status = (String)element;
                }
                if ((element = Integer.valueOf(rs.getInt("linktypeid"))) != null) {
                    linktypeid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("snmpiftype"))) != null) {
                    snmpiftype = (Integer)element;
                }
                if ((element = Long.valueOf(rs.getLong("snmpifspeed"))) != null) {
                    snmpifspeed = (Long)element;
                }
                if ((element = Integer.valueOf(rs.getInt("snmpifoperstatus"))) != null) {
                    snmpifoperstatus = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("snmpifadminstatus"))) != null) {
                    snmpifadminstatus = (Integer)element;
                }
                LOG.debug("getLinksOnElements: id={}", (Object)id);
                link = new LinkInfo(id, nodeid, ifindex, nodeparentid, parentifindex, snmpiftype, snmpifspeed, snmpifoperstatus, snmpifadminstatus, status, linktypeid);
                nodes.add(link);
            }
            rs.close();
            sql = "SELECT datalinkinterface.id, datalinkinterface.nodeid, ifindex,nodeparentid, parentifindex, status, linktypeid, snmpiftype,snmpifspeed,snmpifoperstatus,snmpifadminstatus FROM datalinkinterface left join snmpinterface on datalinkinterface.nodeid = snmpinterface.nodeid WHERE (datalinkinterface.nodeid IN (" + nodelist + ")" + " AND nodeparentid in (" + nodelist + ")) " + "AND status != 'D' and datalinkinterface.ifindex = snmpinterface.snmpifindex";
            LOG.debug("getLinksOnElements: executing query:\n{}", (Object)sql);
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                id = -1;
                nodeid = -1;
                ifindex = -1;
                nodeparentid = -1;
                parentifindex = -1;
                linktypeid = -1;
                status = "U";
                snmpiftype = -1;
                snmpifspeed = -1L;
                snmpifoperstatus = -1;
                snmpifadminstatus = -1;
                element = rs.getInt("id");
                if (element != null) {
                    id = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("nodeid"))) != null) {
                    nodeid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("ifindex"))) != null) {
                    ifindex = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("nodeparentid"))) != null) {
                    nodeparentid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("parentifindex"))) != null) {
                    parentifindex = (Integer)element;
                }
                if ((element = new String(rs.getString("status"))) != null) {
                    status = (String)element;
                }
                if ((element = Integer.valueOf(rs.getInt("linktypeid"))) != null) {
                    linktypeid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("snmpiftype"))) != null) {
                    snmpiftype = (Integer)element;
                }
                if ((element = Long.valueOf(rs.getLong("snmpifspeed"))) != null) {
                    snmpifspeed = (Long)element;
                }
                if ((element = Integer.valueOf(rs.getInt("snmpifoperstatus"))) != null) {
                    snmpifoperstatus = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("snmpifadminstatus"))) != null) {
                    snmpifadminstatus = (Integer)element;
                }
                LOG.debug("getLinksOnElements: id={}", (Object)id);
                link = new LinkInfo(id, nodeid, ifindex, nodeparentid, parentifindex, snmpiftype, snmpifspeed, snmpifoperstatus, snmpifadminstatus, status, linktypeid);
                nodes.add(link);
            }
            rs.close();
            sql = "SELECT id,nodeid, ifindex,nodeparentid, parentifindex, status, linktypeid FROM datalinkinterface WHERE (nodeid IN (" + nodelist + ")" + " AND nodeparentid in (" + nodelist + ")) " + "AND status != 'D'";
            LOG.debug("getLinksOnElements: executing query:\n{}", (Object)sql);
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                id = -1;
                nodeid = -1;
                ifindex = -1;
                nodeparentid = -1;
                parentifindex = -1;
                linktypeid = -1;
                status = "U";
                snmpiftype = -1;
                snmpifspeed = -1L;
                snmpifoperstatus = -1;
                snmpifadminstatus = -1;
                element = rs.getInt("id");
                if (element != null) {
                    id = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("nodeid"))) != null) {
                    nodeid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("ifindex"))) != null) {
                    ifindex = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("nodeparentid"))) != null) {
                    nodeparentid = (Integer)element;
                }
                if ((element = Integer.valueOf(rs.getInt("parentifindex"))) != null) {
                    parentifindex = (Integer)element;
                }
                if ((element = new String(rs.getString("status"))) != null) {
                    status = (String)element;
                }
                if ((element = Integer.valueOf(rs.getInt("linktypeid"))) != null) {
                    linktypeid = (Integer)element;
                }
                LOG.debug("getLinksOnElements: id={}", (Object)id);
                link = new LinkInfo(id, nodeid, ifindex, nodeparentid, parentifindex, snmpiftype, snmpifspeed, snmpifoperstatus, snmpifadminstatus, status, linktypeid);
                nodes.add(link);
            }
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                LOG.error("Exception while getting links on elements {}", allnodes, (Object)e);
                throw new MapsException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return nodes;
    }

    @Override
    public Set<Integer> getNodeIdsBySource(String query) throws MapsException {
        if (query == null) {
            return this.getAllNodes();
        }
        HashSet<Integer> nodes = new HashSet<Integer>();
        Connection conn = this.createConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = query;
            LOG.debug("Applying filters for source  '{}'", (Object)sqlQuery);
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlQuery);
            while (rs.next()) {
                nodes.add(rs.getInt(1));
            }
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                throw new MapsException("Exception while getting nodes by source label " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return nodes;
    }

    private Set<Integer> getAllNodes() throws MapsException {
        Connection conn = this.createConnection();
        HashSet<Integer> nodes = new HashSet<Integer>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            String sqlQuery = "select distinct nodeid from ipinterface";
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlQuery);
            while (rs.next()) {
                nodes.add(rs.getInt(1));
            }
            rs.close();
            statement.close();
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                throw new MapsException("Exception while getting all nodes " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        return nodes;
    }

    @Override
    public boolean isElementDeleted(int elementId, String type) throws MapsException {
        LOG.debug("isElementNotDeleted: elementId={} type= {}", (Object)elementId, (Object)type);
        if (type.equals("M")) {
            return this.isMapInRow(elementId);
        }
        if (type.equals("N")) {
            return this.isNodeInRow(elementId);
        }
        return false;
    }

    private boolean isMapInRow(int mapId) throws MapsException {
        Connection conn = this.createConnection();
        boolean isThere = false;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("SELECT mapid FROM map WHERE MAPID = ?");
            statement.setInt(1, mapId);
            rs = statement.executeQuery();
            if (rs == null) {
                throw new IllegalArgumentException("rs parameter cannot be null");
            }
            isThere = !rs.next();
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                throw new MapsException("Exception while getting mapid " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        LOG.debug("isMapInRow: elementId={}is There: {}", (Object)mapId, (Object)isThere);
        return isThere;
    }

    private boolean isNodeInRow(int nodeId) throws MapsException {
        Connection conn = this.createConnection();
        boolean isThere = false;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("SELECT nodeid FROM NODE WHERE NODEID = ?");
            statement.setInt(1, nodeId);
            rs = statement.executeQuery();
            if (rs == null) {
                throw new IllegalArgumentException("rs parameter cannot be null");
            }
            isThere = !rs.next();
            rs.close();
            statement.close();
            this.closeResultSet(rs);
            this.closeStatement(statement);
        }
        catch (Throwable e) {
            try {
                throw new MapsException("Exception while getting nodeid " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(statement);
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        this.releaseConnection(conn);
        LOG.debug("isNodeInRow: elementId={}is There: {}", (Object)nodeId, (Object)isThere);
        return isThere;
    }

    private String getLabel(String fqdn) {
        if (fqdn.indexOf(46) > 0 && !this.validate(fqdn)) {
            return fqdn.substring(0, fqdn.indexOf(46));
        }
        return fqdn;
    }

    private boolean validate(String ip) {
        Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }
}

