/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class SearchMapsController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(SearchMapsController.class);
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int mapWidth = WebSecurityUtils.safeParseInt((String)request.getParameter("MapWidth"));
        int mapHeight = WebSecurityUtils.safeParseInt((String)request.getParameter("MapHeight"));
        LOG.debug("Current mapWidth={} and MapHeight={}", (Object)mapWidth, (Object)mapHeight);
        int d = WebSecurityUtils.safeParseInt((String)request.getParameter("MapElemDimension"));
        LOG.debug("default element dimension: {}", (Object)d);
        String elems = request.getParameter("elems");
        LOG.debug("Adding Searching Maps: elems={}", (Object)elems);
        int n = mapWidth / 4 / d;
        int k = mapHeight / 2 / d;
        LOG.debug("Max number of element on the row: {}", (Object)n);
        LOG.debug("Max number of element in the map: {}", (Object)(n * k));
        String[] smapids = elems.split(",");
        LOG.debug("Map Element to add to the Search Map: {}", (Object)smapids.length);
        while (smapids.length > n * k) {
            LOG.info("the map dimension is too big: resizing");
            LOG.info("new element dimension: {}", (Object)(d -= 5));
            n = mapWidth / 4 / d;
            k = mapHeight / 2 / d;
            LOG.debug("Recalculated - Max number of element on the row: {}", (Object)n);
            LOG.debug("Recalculated - Max number of element in the map: {}", (Object)(n * k));
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            ArrayList<VElement> velems = new ArrayList<VElement>();
            int x = -1;
            int y = 0;
            int s = 1;
            for (int i = 0; i < smapids.length; ++i) {
                if (x < n) {
                    ++x;
                } else {
                    ++y;
                    if (s == 1) {
                        x = 1;
                        --s;
                    } else {
                        x = 0;
                        ++s;
                    }
                }
                velems.add(this.manager.newElement(-3, new Integer(smapids[i]), "M", null, x * 4 * d + s * 2 * d, y * 2 * d + d));
            }
            VMap map = this.manager.searchMap(request.getRemoteUser(), request.getRemoteUser(), mapWidth, mapHeight, velems);
            LOG.debug("Got search map from manager {}", (Object)map);
            bw.write(ResponseAssembler.getMapResponse(map));
        }
        catch (Throwable e) {
            LOG.error("Error while adding Maps: ", e);
            bw.write(ResponseAssembler.getMapErrorResponse("SearchMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

