/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.map.MapsException;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class SaveMapController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(SaveMapController.class);
    private Manager manager;
    private static List<VElement> elems = null;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        int mapId = WebSecurityUtils.safeParseInt((String)request.getParameter("MapId"));
        String mapName = request.getParameter("MapName");
        String mapBackground = request.getParameter("MapBackground");
        int mapWidth = WebSecurityUtils.safeParseInt((String)request.getParameter("MapWidth"));
        int mapHeight = WebSecurityUtils.safeParseInt((String)request.getParameter("MapHeight"));
        String query = request.getQueryString();
        String queryNodes = request.getParameter("Nodes");
        LOG.debug("Saving map {} the query received is '{}'", (Object)mapName, (Object)query);
        LOG.debug("Saving map {} the data received is '{}'", (Object)mapName, (Object)queryNodes);
        try {
            VMap map = this.manager.openMap();
            if (mapId != -2 && map.isNew()) {
                map = this.manager.openMap(mapId, request.getRemoteUser(), false);
            }
            LOG.debug("Instantiating new elems ArrayList");
            elems = new ArrayList<VElement>();
            StringTokenizer st = new StringTokenizer(queryNodes, "*");
            while (st.hasMoreTokens()) {
                String nodeToken = st.nextToken();
                StringTokenizer nodeST = new StringTokenizer(nodeToken, ",");
                int counter = 1;
                String icon = "";
                String type = "N";
                int id = 0;
                int x = 0;
                int y = 0;
                while (nodeST.hasMoreTokens()) {
                    String tmp = nodeST.nextToken();
                    if (counter == 1) {
                        id = WebSecurityUtils.safeParseInt((String)tmp);
                    }
                    if (counter == 2) {
                        x = WebSecurityUtils.safeParseInt((String)tmp);
                    }
                    if (counter == 3) {
                        y = WebSecurityUtils.safeParseInt((String)tmp);
                    }
                    if (counter == 4) {
                        icon = tmp;
                    }
                    if (counter == 5) {
                        type = tmp;
                    }
                    ++counter;
                }
                if (!type.equals("N") && !type.equals("M")) {
                    throw new MapsException("Map element type " + type + " not valid! Valid values are:" + "N" + " and " + "M");
                }
                String label = null;
                if (map.getElement(id, type) != null && map.getElement(id, type).getLabel() != null) {
                    LOG.debug("preserving the label: {}", (Object)map.getElement(id, type).getLabel());
                    label = map.getElement(id, type).getLabel();
                }
                VElement ve = this.manager.newElement(map.getId(), id, type, icon, x, y);
                if (label != null) {
                    ve.setLabel(label);
                }
                LOG.debug("adding map element to map with id: {}{} and label: {}", new Object[]{id, type, ve.getLabel()});
                elems.add(ve);
            }
            map.removeAllLinks();
            map.removeAllElements();
            map.addElements(elems);
            map.setUserLastModifies(request.getRemoteUser());
            map.setName(mapName);
            map.setBackground(mapBackground);
            map.setWidth(mapWidth);
            map.setHeight(mapHeight);
            if (map.isNew()) {
                LOG.debug("Map is New Map");
                map.setType("U");
                map.setAccessMode("RW");
            } else if (map.getType().trim().equalsIgnoreCase("A")) {
                LOG.debug("Map is Automated Map, saving as Static");
                map.setType("S");
            }
            mapId = this.manager.save(map);
            LOG.info("{} Map saved. With map id: {}", (Object)map.getName(), (Object)mapId);
            if (map.isNew()) {
                map.setId(mapId);
            }
            bw.write(ResponseAssembler.getSaveMapResponse(map));
        }
        catch (Throwable e) {
            LOG.error("Map save error: {}", (Object)e, (Object)e);
            bw.write(ResponseAssembler.getMapErrorResponse("admin/SaveMap"));
        }
        finally {
            bw.close();
            LOG.info("Sending response to the client");
        }
        return null;
    }
}

