/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.map.MapNotFoundException;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class RefreshMapController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshMapController.class);
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter("action");
        LOG.debug("Received action={}", (Object)action);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        VMap map = null;
        try {
            map = this.manager.openMap();
            if (action.equals("Refresh")) {
                map = this.manager.refreshMap(map);
            }
            if (action.equals("Reload")) {
                map = this.manager.reloadMap(map);
            }
            if (map == null) {
                throw new MapNotFoundException();
            }
            bw.write(ResponseAssembler.getRefreshResponse(map));
        }
        catch (Throwable e) {
            LOG.error("Error while refreshing map. Action {}", (Object)action, (Object)e);
            bw.write(ResponseAssembler.getMapErrorResponse(action));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

