/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections15.Transformer;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VLink;
import org.opennms.web.map.view.VMap;
import org.opennms.web.map.view.VMapInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OpenMapController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMapController.class);
    public static final int ELBOW_ROOM = 200;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.debug(request.getQueryString());
        String mapIdStr = request.getParameter("MapId");
        LOG.debug("MapId={}", (Object)mapIdStr);
        String mapWidthStr = request.getParameter("MapWidth");
        LOG.debug("MapWidth={}", (Object)mapWidthStr);
        String mapHeightStr = request.getParameter("MapHeight");
        LOG.debug("MapHeight={}", (Object)mapHeightStr);
        String adminModeStr = request.getParameter("adminMode");
        LOG.debug("adminMode={}", (Object)adminModeStr);
        String user = request.getRemoteUser();
        if (request.isUserInRole("ROLE_ADMIN")) {
            LOG.info("{} has Admin admin Role", (Object)user);
        }
        float widthFactor = 1.0f;
        float heightFactor = 1.0f;
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            int mapWidth = WebSecurityUtils.safeParseInt((String)mapWidthStr);
            int mapHeight = WebSecurityUtils.safeParseInt((String)mapHeightStr);
            LOG.debug("Current mapWidth={} and MapHeight={}", (Object)mapWidth, (Object)mapHeight);
            VMap map = null;
            if (mapIdStr != null) {
                int mapid = WebSecurityUtils.safeParseInt((String)mapIdStr);
                LOG.debug("Opening map {} for user {}", (Object)mapid, (Object)user);
                map = this.manager.openMap(mapid, user, !adminModeStr.equals("true"));
            } else {
                LOG.debug("Try to Opening default map");
                VMapInfo defaultmapinfo = this.manager.getDefaultMapsMenu(user);
                map = defaultmapinfo != null ? this.manager.openMap(defaultmapinfo.getId(), user, !adminModeStr.equals("true")) : this.manager.openMap();
            }
            if (map != null) {
                int dbMapWidth = map.getWidth();
                int dbMapHeight = map.getHeight();
                widthFactor = (float)mapWidth / (float)dbMapWidth;
                heightFactor = (float)mapHeight / (float)dbMapHeight;
                LOG.debug("Old saved mapWidth={} and MapHeight={}", (Object)dbMapWidth, (Object)dbMapHeight);
                LOG.debug("widthFactor={}", (Object)Float.valueOf(widthFactor));
                LOG.debug("heightFactor={}", (Object)Float.valueOf(heightFactor));
                LOG.debug("Setting new width and height to the session map");
                map.setHeight(mapHeight);
                map.setWidth(mapWidth);
                for (VElement ve : map.getElements().values()) {
                    ve.setX((int)((float)ve.getX() * widthFactor));
                    ve.setY((int)((float)ve.getY() * heightFactor));
                }
                SparseGraph jungGraph = new SparseGraph();
                for (VElement ve : map.getElements().values()) {
                    jungGraph.addVertex((Object)ve);
                }
                for (VLink vl : map.getLinks()) {
                    jungGraph.addEdge((Object)vl, (Object)map.getElement(vl.getFirst()), (Object)map.getElement(vl.getSecond()));
                }
                KKLayout layout = new KKLayout((Graph)jungGraph);
                layout.setInitializer(this.initializer(map));
                layout.setSize(this.selectLayoutSize(map));
                while (!layout.done()) {
                    layout.step();
                }
                int vertexCount = map.getElements().size();
                for (VElement ve : map.getElements().values()) {
                    LOG.debug("---------Element {}---------", (Object)ve.getLabel());
                    LOG.debug("dbcoor: X={} Y={}", (Object)ve.getX(), (Object)ve.getY());
                    LOG.debug("kkcoor: X={} Y={}", (Object)layout.getX((Object)ve), (Object)layout.getY((Object)ve));
                    LOG.debug("kkcoor: X={} Y={}", (Object)((int)layout.getX((Object)ve)), (Object)((int)layout.getY((Object)ve)));
                    LOG.debug("");
                    if (vertexCount >= 10) {
                        ve.setX((int)layout.getX((Object)ve) - 100);
                        ve.setY((int)layout.getY((Object)ve) - 100);
                    } else {
                        ve.setX((int)layout.getX((Object)ve));
                        ve.setY((int)layout.getY((Object)ve));
                    }
                    LOG.debug("vmspcoor: X={} Y={}", (Object)ve.getX(), (Object)ve.getY());
                }
            }
            bw.write(ResponseAssembler.getMapResponse(map));
        }
        catch (Throwable e) {
            LOG.error("Error while opening map with id:{}, for user:{}", new Object[]{mapIdStr, user, e});
            bw.write(ResponseAssembler.getMapErrorResponse("OpenMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }

    protected Transformer<VElement, Point2D> initializer(VMap layout) {
        return new Transformer<VElement, Point2D>(){

            public Point2D transform(VElement v) {
                return new Point(v.getX(), v.getY());
            }
        };
    }

    protected Dimension selectLayoutSize(VMap g) {
        double height = 1.1 * (double)g.getHeight();
        double width = height * 16.0 / 9.0;
        return new Dimension((int)width, (int)height);
    }
}

