/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class NewMapController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(NewMapController.class);
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int mapWidth = WebSecurityUtils.safeParseInt((String)request.getParameter("MapWidth"));
        int mapHeight = WebSecurityUtils.safeParseInt((String)request.getParameter("MapHeight"));
        LOG.debug("Current mapWidth={} and MapHeight={}", (Object)mapWidth, (Object)mapHeight);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            LOG.info("New Map in admin mode: creating new map");
            VMap map = this.manager.newMap(request.getRemoteUser(), request.getRemoteUser(), mapWidth, mapHeight);
            bw.write(ResponseAssembler.getMapResponse(map));
        }
        catch (Throwable e) {
            LOG.error("Error while creating new map for user:{}", (Object)request.getRemoteUser(), (Object)e);
            bw.write(ResponseAssembler.getMapErrorResponse("admin/NewMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

