/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class DeleteMapController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteMapController.class);
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.info("Deleting map");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            this.manager.deleteMap();
            bw.write(ResponseAssembler.getActionOKMapResponse("admin/DeleteMap"));
        }
        catch (Throwable e) {
            LOG.error("Error deleting map", e);
            bw.write(ResponseAssembler.getMapErrorResponse("admin/DeleteMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

