/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.CatFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class AddNodesController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(AddNodesController.class);
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter("action");
        String elems = request.getParameter("elems");
        LOG.debug("Adding Nodes action:{}, elems={}", (Object)action, (Object)elems);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            int i;
            Integer[] nodeids = null;
            boolean actionfound = false;
            if (action.equals("admin/AddNodes")) {
                LOG.debug("Adding nodes by id: {}", (Object)elems);
                actionfound = true;
                String[] snodeids = elems.split(",");
                nodeids = new Integer[snodeids.length];
                for (i = 0; i < snodeids.length; ++i) {
                    nodeids[i] = new Integer(snodeids[i]);
                }
            }
            if (action.equals("AddNodesByCategory")) {
                LOG.debug("Adding nodes by category: {}", (Object)elems);
                actionfound = true;
                String categoryName = elems;
                CategoryFactory.init();
                CatFactory cf = CategoryFactory.getInstance();
                cf.getReadLock().lock();
                try {
                    String rule = cf.getEffectiveRule(categoryName);
                    List nodeIPs = FilterDaoFactory.getInstance().getIPAddressList(rule);
                    LOG.debug("ips found: {}", (Object)nodeIPs.toString());
                    nodeids = new Integer[nodeIPs.size()];
                    for (int i2 = 0; i2 < nodeIPs.size(); ++i2) {
                        InetAddress nodeIp = (InetAddress)nodeIPs.get(i2);
                        List<Integer> ids = NetworkElementFactory.getInstance(this.getServletContext()).getNodeIdsWithIpLike(InetAddressUtils.str((InetAddress)nodeIp));
                        LOG.debug("Ids by ipaddress {}: {}", (Object)nodeIp, (Object)ids.toString());
                        nodeids[i2] = ids.get(0);
                    }
                }
                finally {
                    cf.getReadLock().unlock();
                }
            }
            if (action.equals("AddNodesByLabel")) {
                LOG.debug("Adding nodes by label: {}", (Object)elems);
                actionfound = true;
                List<OnmsNode> nodes = NetworkElementFactory.getInstance(this.getServletContext()).getAllNodes();
                nodeids = new Integer[nodes.size()];
                for (i = 0; i < nodes.size(); ++i) {
                    nodeids[i] = nodes.get(i).getId();
                }
            }
            if (action.equals("AddRange")) {
                LOG.debug("Adding nodes by range: {}", (Object)elems);
                actionfound = true;
                nodeids = NetworkElementFactory.getInstance(this.getServletContext()).getNodeIdsWithIpLike(elems).toArray(new Integer[0]);
            }
            if (action.equals("AddNodesNeig")) {
                LOG.debug("Adding nodes neighbor of:{}", (Object)elems);
                actionfound = true;
                nodeids = NetworkElementFactory.getInstance(this.getServletContext()).getLinkedNodeIdOnNode(WebSecurityUtils.safeParseInt((String)elems)).toArray(new Integer[0]);
            }
            if (action.equals("AddNodesWithNeig")) {
                LOG.debug("Adding nodes with neighbor of:{}", (Object)elems);
                actionfound = true;
                Set<Integer> linkednodeids = NetworkElementFactory.getInstance(this.getServletContext()).getLinkedNodeIdOnNode(WebSecurityUtils.safeParseInt((String)elems));
                linkednodeids.add(new Integer(elems));
                nodeids = linkednodeids.toArray(new Integer[linkednodeids.size()]);
            }
            VMap map = this.manager.openMap();
            LOG.debug("Got map from manager {}", (Object)map);
            ArrayList<VElement> velems = new ArrayList<VElement>();
            if (actionfound) {
                LOG.debug("Before Checking map contains elems");
                for (int i3 = 0; i3 < nodeids.length; ++i3) {
                    int elemId = nodeids[i3];
                    if (map.containsElement(elemId, "N")) {
                        LOG.debug("Action: {} . Map Contains Element: {}", (Object)action, (Object)(elemId + "N"));
                        continue;
                    }
                    velems.add(this.manager.newElement(map.getId(), elemId, "N"));
                }
                map = this.manager.addElements(map, velems);
                LOG.debug("After getting/adding links");
                bw.write(ResponseAssembler.getAddElementResponse(null, velems, map.getLinks()));
            }
        }
        catch (Throwable e) {
            LOG.error("Error while adding nodes for action: {}", (Object)action, (Object)e);
            bw.write(ResponseAssembler.getMapErrorResponse(action));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

