/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.map.MapsLoggingController;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class AddMapsController
extends MapsLoggingController {
    private static final Logger LOG = LoggerFactory.getLogger(AddMapsController.class);
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        String elems = request.getParameter("elems");
        LOG.debug("Adding Maps: elems={}", (Object)elems);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            VMap map = this.manager.openMap();
            ArrayList<VElement> velems = new ArrayList<VElement>();
            ArrayList<Integer> mapsWithLoop = new ArrayList<Integer>();
            LOG.debug("Got map from manager {}", (Object)map);
            LOG.debug("Adding maps by id: {}", (Object)elems);
            String[] smapids = elems.split(",");
            for (int i = 0; i < smapids.length; ++i) {
                Integer id = new Integer(smapids[i]);
                if (map.containsElement(id, "M")) {
                    LOG.debug(" Map Contains Element: {}", (Object)(id + "M"));
                    continue;
                }
                boolean foundLoop = this.manager.foundLoopOnMaps(map, id);
                if (foundLoop) {
                    mapsWithLoop.add(id);
                    continue;
                }
                velems.add(this.manager.newElement(map.getId(), id, "M"));
            }
            map = this.manager.addElements(map, velems);
            bw.write(ResponseAssembler.getAddElementResponse(mapsWithLoop, velems, map.getLinks()));
        }
        catch (Throwable e) {
            LOG.error("Error while adding Maps: ", e);
            bw.write(ResponseAssembler.getMapErrorResponse("admin/AddMaps"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

