/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.group;

import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.web.group.WebGroup;
import org.opennms.web.group.WebGroupRepository;
import org.opennms.web.services.GroupService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultWebGroupRepository
implements WebGroupRepository,
InitializingBean {
    @Autowired
    GroupService groupService;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    @Transactional
    public boolean groupExists(String groupName) {
        return this.groupService.existsGroup(groupName);
    }

    @Override
    @Transactional
    public WebGroup getGroup(String groupName) {
        Group group = this.groupService.getGroup(groupName);
        WebGroup webGroup = new WebGroup(group, this.groupService.getAuthorizedCategoriesAsString(groupName));
        return webGroup;
    }

    @Override
    @Transactional
    public void saveGroup(WebGroup webGroup) {
        Group group = this.groupService.getGroup(webGroup.getName());
        if (group == null) {
            group = new Group();
            group.setName(webGroup.getName());
        }
        group.setComments(webGroup.getComments());
        group.setDutySchedule(webGroup.getDutySchedules());
        group.setUser(webGroup.getUsers());
        if (!webGroup.getDefaultMap().equals("")) {
            group.setDefaultMap(webGroup.getDefaultMap());
        }
        this.groupService.saveGroup(group, webGroup.getAuthorizedCategories());
    }

    @Override
    @Transactional
    public void deleteGroup(String groupName) {
        this.groupService.deleteGroup(groupName);
    }

    @Override
    @Transactional
    public void renameGroup(String oldName, String newName) {
        this.groupService.renameGroup(oldName, newName);
    }
}

