/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.event.filter.AcknowledgedByFilter;
import org.opennms.web.event.filter.AfterDateFilter;
import org.opennms.web.event.filter.AlarmIDFilter;
import org.opennms.web.event.filter.BeforeDateFilter;
import org.opennms.web.event.filter.ExactUEIFilter;
import org.opennms.web.event.filter.IPAddrLikeFilter;
import org.opennms.web.event.filter.IfIndexFilter;
import org.opennms.web.event.filter.InterfaceFilter;
import org.opennms.web.event.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.event.filter.LogMessageSubstringFilter;
import org.opennms.web.event.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.event.filter.NegativeExactUEIFilter;
import org.opennms.web.event.filter.NegativeInterfaceFilter;
import org.opennms.web.event.filter.NegativeNodeFilter;
import org.opennms.web.event.filter.NegativePartialUEIFilter;
import org.opennms.web.event.filter.NegativeServiceFilter;
import org.opennms.web.event.filter.NegativeSeverityFilter;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.NodeNameLikeFilter;
import org.opennms.web.event.filter.PartialUEIFilter;
import org.opennms.web.event.filter.ServiceFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OneArgFilter;

public abstract class EventUtil {
    public static final int LAST_HOUR_RELATIVE_TIME = 1;
    public static final int LAST_FOUR_HOURS_RELATIVE_TIME = 2;
    public static final int LAST_EIGHT_HOURS_RELATIVE_TIME = 3;
    public static final int LAST_TWELVE_HOURS_RELATIVE_TIME = 4;
    public static final int LAST_DAY_RELATIVE_TIME = 5;
    public static final int LAST_WEEK_RELATIVE_TIME = 6;
    public static final int LAST_MONTH_RELATIVE_TIME = 7;

    public static Filter getFilter(String filterString, ServletContext servletContext) {
        String value;
        String type;
        if (filterString == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OneArgFilter filter = null;
        StringTokenizer tokens = new StringTokenizer(filterString, "=");
        try {
            type = tokens.nextToken();
            value = tokens.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Could not tokenize filter string: " + filterString);
        }
        if (type.equals("severity")) {
            filter = new SeverityFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("nodenamelike")) {
            filter = new NodeNameLikeFilter(value);
        } else if (type.equals("interface")) {
            filter = new InterfaceFilter(value);
        } else if (type.equals("service")) {
            filter = new ServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("ifindex")) {
            filter = new IfIndexFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("partialUei")) {
            filter = new PartialUEIFilter(value);
        } else if (type.equals("exactUei")) {
            filter = new ExactUEIFilter(value);
        } else if (type.equals("acknowledgedBy")) {
            filter = new AcknowledgedByFilter(value);
        } else if (type.equals("severityNot")) {
            filter = new NegativeSeverityFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("nodenot")) {
            filter = new NegativeNodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("interfacenot")) {
            filter = new NegativeInterfaceFilter(value);
        } else if (type.equals("servicenot")) {
            filter = new NegativeServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("partialUeiNot")) {
            filter = new NegativePartialUEIFilter(value);
        } else if (type.equals("exactUeiNot")) {
            filter = new NegativeExactUEIFilter(value);
        } else if (type.equals("acknowledgedByNot")) {
            filter = new NegativeAcknowledgedByFilter(value);
        } else if (type.equals("iplike")) {
            filter = new IPAddrLikeFilter(value);
        } else if (type.equals("msgsub")) {
            filter = new LogMessageSubstringFilter(value);
        } else if (type.equals("msgmatchany")) {
            filter = new LogMessageMatchesAnyFilter(value);
        } else if (type.equals("beforedate")) {
            filter = new BeforeDateFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("afterdate")) {
            filter = new AfterDateFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("alarm")) {
            filter = new AlarmIDFilter(WebSecurityUtils.safeParseInt((String)value));
        }
        return filter;
    }

    public static String getFilterString(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return filter.getDescription();
    }

    public static Filter getRelativeTimeFilter(int relativeTime) {
        AfterDateFilter filter = null;
        Calendar now = Calendar.getInstance();
        switch (relativeTime) {
            case 1: {
                now.add(10, -1);
                break;
            }
            case 2: {
                now.add(10, -4);
                break;
            }
            case 3: {
                now.add(10, -8);
                break;
            }
            case 4: {
                now.add(10, -12);
                break;
            }
            case 5: {
                now.add(10, -24);
                break;
            }
            case 6: {
                now.add(10, -168);
                break;
            }
            case 7: {
                now.add(2, -1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relative time constant: " + relativeTime);
            }
        }
        filter = new AfterDateFilter(now.getTime());
        return filter;
    }

    public static List<Filter> getFilterList(String[] filterStrings, ServletContext servletContext) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (String filterString : filterStrings) {
                Filter filter = EventUtil.getFilter(filterString, servletContext);
                if (filter == null) continue;
                filterList.add(filter);
            }
        }
        return filterList;
    }
}

