/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.Date;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.web.api.Util;

public class Vlan {
    private final int m_nodeId;
    private final int m_vlanId;
    private final String m_vlanname;
    private final String m_vlantype;
    private final String m_vlanstatus;
    private final String m_lastPollTime;
    private final String m_status;

    Vlan(OnmsVlan vlan) {
        this.m_nodeId = vlan.getNode().getId();
        this.m_vlanId = vlan.getVlanId();
        this.m_vlanname = vlan.getVlanName();
        this.m_vlantype = OnmsVlan.VlanType.getVlanTypeString((Integer)vlan.getVlanType().getIntCode());
        this.m_vlanstatus = OnmsVlan.VlanStatus.getVlanStatusString((Integer)vlan.getVlanStatus().getIntCode());
        this.m_lastPollTime = Util.formatDateToUIString((Date)vlan.getLastPollTime());
        this.m_status = OnmsArpInterface.StatusType.getStatusString((char)vlan.getStatus().getCharCode());
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Vlan id = " + this.m_vlanId + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public String getLastPollTime() {
        return this.m_lastPollTime;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getStatus() {
        return this.m_status;
    }

    public String getStatusString() {
        return this.m_status;
    }

    public String getVlanColorIdentifier() {
        int red = 128;
        int green = 128;
        int blue = 128;
        int redoffset = 47;
        int greenoffset = 29;
        int blueoffset = 23;
        if (this.m_vlanId == 0) {
            return "";
        }
        if (this.m_vlanId == 1) {
            return "#FFFFFF";
        }
        red = (red + this.m_vlanId * redoffset) % 255;
        green = (green + this.m_vlanId * greenoffset) % 255;
        blue = (blue + this.m_vlanId * blueoffset) % 255;
        if (red < 64) {
            red += 64;
        }
        if (green < 64) {
            green += 64;
        }
        if (blue < 64) {
            blue += 64;
        }
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }

    public int getVlanId() {
        return this.m_vlanId;
    }

    public String getVlanName() {
        return this.m_vlanname;
    }

    public String getVlanStatus() {
        return this.m_vlanstatus;
    }

    public String getVlanStatusString() {
        return this.m_vlanstatus;
    }

    public String getVlanType() {
        return this.m_vlantype;
    }

    public String getVlanTypeString() {
        return this.m_vlantype;
    }
}

