/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.Date;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.web.api.Util;

public class StpNode {
    int m_nodeId;
    String m_basenumports = "";
    String m_basetype;
    String m_stpprotocolspecification = "";
    String m_stppriority = "";
    String m_stprootcost = "";
    String m_stprootport = "";
    int m_basevlan;
    String m_basevlanname = "default";
    String m_basebridgeaddress;
    String m_stpdesignatedroot = "";
    String m_lastPollTime;
    String m_status;
    int m_stprootnodeid;

    StpNode() {
    }

    StpNode(OnmsStpNode node) {
        this.m_nodeId = node.getNode().getId();
        this.m_basebridgeaddress = node.getBaseBridgeAddress();
        this.m_basevlan = node.getBaseVlan();
        this.m_lastPollTime = Util.formatDateToUIString((Date)node.getLastPollTime());
        this.m_status = OnmsArpInterface.StatusType.getStatusString((char)node.getStatus().getCharCode());
        if (node.getBaseNumPorts() != null) {
            this.m_basenumports = node.getBaseNumPorts().toString();
        }
        if (node.getBaseType() != null) {
            this.m_basetype = OnmsStpNode.BridgeBaseType.getBridgeBaseTypeString((Integer)node.getBaseType().getIntCode());
        }
        if (node.getStpProtocolSpecification() != null) {
            this.m_stpprotocolspecification = OnmsStpNode.StpProtocolSpecification.getStpProtocolSpecificationString((Integer)node.getStpProtocolSpecification().getIntCode());
        }
        if (node.getStpPriority() != null) {
            this.m_stppriority = node.getStpPriority().toString();
        }
        if (node.getStpRootCost() != null) {
            this.m_stprootcost = node.getStpRootCost().toString();
        }
        if (node.getStpRootPort() != null) {
            this.m_stprootport = node.getStpRootPort().toString();
        }
        if (node.getBaseVlanName() != null) {
            this.m_basevlanname = node.getBaseVlanName();
        }
        if (node.getStpDesignatedRoot() != null) {
            this.m_stpdesignatedroot = node.getStpDesignatedRoot();
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Bridge number of ports = " + this.m_basenumports + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public String get_basebridgeaddress() {
        return this.m_basebridgeaddress;
    }

    public String get_basenumports() {
        return this.m_basenumports;
    }

    public String get_basetype() {
        return this.m_basetype;
    }

    public String getBaseType() {
        return this.m_basetype;
    }

    public int get_basevlan() {
        return this.m_basevlan;
    }

    public String get_lastPollTime() {
        return this.m_lastPollTime;
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public String get_status() {
        return this.m_status;
    }

    public String get_stpdesignatedroot() {
        return this.m_stpdesignatedroot;
    }

    public String get_stppriority() {
        return this.m_stppriority;
    }

    public String get_stpprotocolspecification() {
        return this.m_stpprotocolspecification;
    }

    public String getStpProtocolSpecification() {
        return this.m_stpprotocolspecification;
    }

    public String get_stprootcost() {
        return this.m_stprootcost;
    }

    public String get_stprootport() {
        return this.m_stprootport;
    }

    public int get_stprootnodeid() {
        return this.m_stprootnodeid;
    }

    public String getBaseVlanName() {
        return this.m_basevlanname;
    }

    public String getStatusString() {
        return this.m_status;
    }

    public String getVlanColorIdentifier() {
        int red = 128;
        int green = 128;
        int blue = 128;
        int redoffset = 47;
        int greenoffset = 29;
        int blueoffset = 23;
        if (this.m_basevlan == 0) {
            return "";
        }
        if (this.m_basevlan == 1) {
            return "#FFFFFF";
        }
        red = (red + this.m_basevlan * redoffset) % 255;
        green = (green + this.m_basevlan * greenoffset) % 255;
        blue = (blue + this.m_basevlan * blueoffset) % 255;
        if (red < 64) {
            red += 64;
        }
        if (green < 64) {
            green += 64;
        }
        if (blue < 64) {
            blue += 64;
        }
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }
}

