/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.Date;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.web.api.Util;

public class StpInterface {
    int m_nodeId;
    int m_bridgeport;
    int m_ifindex;
    String m_stpportstate = "";
    String m_stpportpathcost = "";
    String m_stpportdesignatedcost = "";
    int m_stpvlan;
    String m_ipaddr = "";
    String m_stpdesignatedroot = "";
    String m_stpdesignatedbridge = "";
    String m_stpdesignatedport = "";
    String m_lastPollTime;
    String m_status;
    int m_stprootnodeid;
    int m_stpbridgenodeid;

    StpInterface() {
    }

    StpInterface(OnmsStpInterface stpinterf) {
        this.m_nodeId = stpinterf.getNode().getId();
        this.m_bridgeport = stpinterf.getBridgePort();
        this.m_ifindex = stpinterf.getIfIndex();
        this.m_stpvlan = stpinterf.getVlan();
        this.m_lastPollTime = Util.formatDateToUIString((Date)stpinterf.getLastPollTime());
        this.m_status = OnmsArpInterface.StatusType.getStatusString((char)stpinterf.getStatus().getCharCode());
        if (stpinterf.getStpPortState() != null) {
            this.m_stpportstate = OnmsStpInterface.StpPortStatus.getStpPortStatusString((Integer)stpinterf.getStpPortState().getIntCode());
        }
        if (stpinterf.getStpPortPathCost() != null) {
            this.m_stpportpathcost = stpinterf.getStpPortPathCost().toString();
        }
        if (stpinterf.getStpPortDesignatedCost() != null) {
            this.m_stpportdesignatedcost = stpinterf.getStpPortDesignatedCost().toString();
        }
        if (stpinterf.getStpPortDesignatedBridge() != null) {
            this.m_stpdesignatedbridge = stpinterf.getStpPortDesignatedBridge();
        }
        if (stpinterf.getStpPortDesignatedRoot() != null) {
            this.m_stpdesignatedroot = stpinterf.getStpPortDesignatedRoot();
        }
        if (stpinterf.getStpPortDesignatedPort() != null) {
            this.m_stpdesignatedport = stpinterf.getStpPortDesignatedPort();
        }
    }

    public void setStpRootNodeid(Integer stprootnodeid) {
        this.m_stprootnodeid = stprootnodeid;
    }

    public void setStpBridgeNodeid(Integer stpbridgenodeid) {
        this.m_stpbridgenodeid = stpbridgenodeid;
    }

    public void setIpAddress(String ipaddr) {
        this.m_ipaddr = ipaddr;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Bridge number of ports = " + this.m_bridgeport + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public int get_bridgeport() {
        return this.m_bridgeport;
    }

    public int get_ifindex() {
        return this.m_ifindex;
    }

    public String get_lastPollTime() {
        return this.m_lastPollTime;
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public String get_status() {
        return this.m_status;
    }

    public String get_stpdesignatedbridge() {
        return this.m_stpdesignatedbridge;
    }

    public String get_stpdesignatedport() {
        return this.m_stpdesignatedport;
    }

    public String get_stpdesignatedroot() {
        return this.m_stpdesignatedroot;
    }

    public String get_stpportdesignatedcost() {
        return this.m_stpportdesignatedcost;
    }

    public String get_stpportpathcost() {
        return this.m_stpportpathcost;
    }

    public String get_stpportstate() {
        return this.m_stpportstate;
    }

    public String getStpPortState() {
        return this.m_stpportstate;
    }

    public int get_stpvlan() {
        return this.m_stpvlan;
    }

    public int get_stpbridgenodeid() {
        return this.m_stpbridgenodeid;
    }

    public int get_stprootnodeid() {
        return this.m_stprootnodeid;
    }

    public String get_ipaddr() {
        return this.m_ipaddr;
    }

    public String getStatusString() {
        return this.m_status;
    }

    public String getVlanColorIdentifier() {
        int red = 128;
        int green = 128;
        int blue = 128;
        int redoffset = 47;
        int greenoffset = 29;
        int blueoffset = 23;
        if (this.m_stpvlan == 0) {
            return "";
        }
        if (this.m_stpvlan == 1) {
            return "#FFFFFF";
        }
        red = (red + this.m_stpvlan * redoffset) % 255;
        green = (green + this.m_stpvlan * greenoffset) % 255;
        blue = (blue + this.m_stpvlan * blueoffset) % 255;
        if (red < 64) {
            red += 64;
        }
        if (green < 64) {
            green += 64;
        }
        if (blue < 64) {
            blue += 64;
        }
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }
}

