/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.StpInterfaceDao;
import org.opennms.netmgt.dao.api.StpNodeDao;
import org.opennms.netmgt.dao.api.VlanDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsRestrictions;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.web.element.AtInterface;
import org.opennms.web.element.Interface;
import org.opennms.web.element.IpRouteInterface;
import org.opennms.web.element.LinkInterface;
import org.opennms.web.element.NetworkElementFactoryInterface;
import org.opennms.web.element.Service;
import org.opennms.web.element.StpInterface;
import org.opennms.web.element.StpNode;
import org.opennms.web.element.Vlan;
import org.opennms.web.svclayer.AggregateStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class NetworkElementFactory
implements InitializingBean,
NetworkElementFactoryInterface {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private IpRouteInterfaceDao m_ipRouteInterfaceDao;
    @Autowired
    private StpNodeDao m_stpNodeDao;
    @Autowired
    private StpInterfaceDao m_stpInterfaceDao;
    @Autowired
    private VlanDao m_vlanDao;
    @Autowired
    private MonitoredServiceDao m_monSvcDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private static final Comparator<Interface> INTERFACE_COMPARATOR = new InterfaceComparator();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public static NetworkElementFactoryInterface getInstance(ServletContext servletContext) {
        return NetworkElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static NetworkElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (NetworkElementFactoryInterface)appContext.getBean(NetworkElementFactoryInterface.class);
    }

    @Override
    public String getNodeLabel(int nodeId) {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.eq("id", (Object)nodeId);
        List nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return node.getLabel();
        }
        return null;
    }

    @Override
    public String getIpPrimaryAddress(int nodeId) {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsIpInterface.class);
        cb.and((Restriction)new EqRestriction("node.id", (Object)nodeId), (Restriction)new EqRestriction("isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        List ifaces = this.m_ipInterfaceDao.findMatching(cb.toCriteria());
        if (ifaces.size() > 0) {
            OnmsIpInterface iface = (OnmsIpInterface)ifaces.get(0);
            return InetAddressUtils.str((InetAddress)iface.getIpAddress());
        }
        return null;
    }

    @Override
    public OnmsNode getNode(int nodeId) {
        return (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
    }

    @Override
    public OnmsNode getNode(String lookupCriteria) {
        return this.m_nodeDao.get(lookupCriteria);
    }

    @Override
    public List<OnmsNode> getAllNodes() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"type"), (Criterion)Restrictions.ne((String)"type", (Object)"D")));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesLike(String nodeLabel) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ilike((String)"label", (String)nodeLabel, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"type"), (Criterion)Restrictions.ne((String)"type", (Object)"D"))));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIpLike(String iplike) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class, "node");
        nodeCrit.createCriteria("ipInterfaces", "iface").add(OnmsRestrictions.ipLike((String)iplike)).add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.addOrder(Order.asc((String)"label"));
        nodeCrit.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getNodesWithService(int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("ipInterfaces", "iface");
        criteria.createAlias("iface.monitoredServices", "svc");
        criteria.createAlias("svc.serviceType", "svcType").add((Criterion)Restrictions.eq((String)"svcType.id", (Object)serviceId));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddr(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("snmpInterfaces", "snmpIfaces", 1);
        criteria.createAlias("arpInterfaces", "arpIfaces", 1);
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"snmpIfaces.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"arpIfaces.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE)));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddrAtInterface(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("arpInterfaces", "arpIfaces");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"arpIfaces.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddrFromSnmpInterface(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("snmpInterfaces", "snmpIface");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"snmpIface.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIfAlias(String ifAlias) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("snmpInterfaces", "snmpIface");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"snmpIface.ifAlias", (String)ifAlias, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public String getHostname(String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add(Restrictions.isNotNull((String)"ipHostName"));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        List ipIfaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ipIfaces.size() > 0) {
            OnmsIpInterface iface = (OnmsIpInterface)ipIfaces.get(0);
            return iface.getIpHostName();
        }
        return null;
    }

    @Override
    public Integer getIfIndex(int ipinterfaceid) {
        return this.getIfIndex((OnmsIpInterface)this.m_ipInterfaceDao.get((Serializable)Integer.valueOf(ipinterfaceid)));
    }

    @Override
    public Integer getIfIndex(int nodeID, String ipaddr) {
        return this.getIfIndex(this.m_ipInterfaceDao.get((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeID)), ipaddr));
    }

    private Integer getIfIndex(OnmsIpInterface ipinterface) {
        if (ipinterface != null && ipinterface.getIfIndex() != null) {
            return ipinterface.getIfIndex();
        }
        return -1;
    }

    @Override
    public Interface getInterface(int ipInterfaceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)ipInterfaceId));
        criteria.setFetchMode("snmpInterface", FetchMode.JOIN);
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ifaces.size() > 0) {
            return new Interface((OnmsIpInterface)ifaces.get(0));
        }
        return null;
    }

    @Override
    public Interface getInterface(int nodeId, String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.setFetchMode("snmpInterface", FetchMode.JOIN);
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        return ifaces.size() > 0 ? new Interface((OnmsIpInterface)ifaces.get(0)) : null;
    }

    @Override
    public Interface getInterface(int nodeId, String ipAddress, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add((Criterion)Restrictions.eq((String)"snmpIface.ifIndex", (Object)ifIndex));
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        return ifaces.size() > 0 ? new Interface((OnmsIpInterface)ifaces.get(0)) : null;
    }

    @Override
    public Interface getSnmpInterface(int nodeId, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        List snmpIfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (snmpIfaces.size() > 0) {
            return new Interface((OnmsSnmpInterface)snmpIfaces.get(0));
        }
        return null;
    }

    @Override
    public Interface[] getInterfacesWithIpAddress(String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getInterfacesWithIfAlias(int nodeId, String ifAlias) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.createAlias("node.assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add(Restrictions.ilike((String)"snmpIface.ifAlias", (String)ifAlias, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.createAlias("node.assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllSnmpInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.addOrder(Order.asc((String)"ifIndex"));
        return this.onmsSnmpInterfaces2InterfaceArray(this.m_snmpInterfaceDao.findMatching(criteria));
    }

    private Interface[] onmsSnmpInterfaces2InterfaceArray(List<OnmsSnmpInterface> snmpIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsSnmpInterface snmpIface : snmpIfaces) {
            intfs.add(new Interface(snmpIface));
        }
        return intfs.toArray(new Interface[intfs.size()]);
    }

    @Override
    public Interface[] getActiveInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllInterfaces() {
        return this.getAllInterfaces(true);
    }

    @Override
    public Interface[] getAllInterfaces(boolean includeSnmp) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        if (!includeSnmp) {
            return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
        }
        return this.getInterfaceArrayWithSnmpData(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllManagedIpInterfaces(boolean includeSNMP) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        criteria.add((Criterion)Restrictions.ne((String)"ipAddress", (Object)InetAddressUtils.addr((String)"0.0.0.0")));
        criteria.add(Restrictions.isNotNull((String)"ipAddress"));
        criteria.addOrder(Order.asc((String)"ipHostName"));
        criteria.addOrder(Order.asc((String)"node.id"));
        criteria.addOrder(Order.asc((String)"ipAddress"));
        if (!includeSNMP) {
            return this.getInterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
        }
        return this.getInterfaceArrayWithSnmpData(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Service getService(int nodeId, String ipAddress, int serviceId) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface", 1);
        criteria.createAlias("ipInterface.node", "node", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        List monSvcs = this.m_monSvcDao.findMatching(criteria);
        if (monSvcs.size() > 0) {
            return new Service((OnmsMonitoredService)monSvcs.get(0));
        }
        return null;
    }

    @Override
    public Service getService(int ifServiceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface", 1);
        criteria.createAlias("ipInterface.node", "node", 1);
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)ifServiceId));
        criteria.addOrder(Order.asc((String)"status"));
        List monSvcs = this.m_monSvcDao.findMatching(criteria);
        if (monSvcs.size() > 0) {
            return new Service((OnmsMonitoredService)monSvcs.get(0));
        }
        return null;
    }

    @Override
    public Service[] getAllServices() {
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findAll());
    }

    @Override
    public Service[] getServicesOnInterface(int nodeId, String ipAddress) {
        return this.getServicesOnInterface(nodeId, ipAddress, false);
    }

    @Override
    public Service[] getServicesOnInterface(int nodeId, String ipAddress, boolean includeDeletions) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        if (!includeDeletions) {
            criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        }
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    @Override
    public Service[] getServicesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.createAlias("ipInterface.node", "node");
        criteria.createAlias("serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    @Override
    public Service[] getServicesOnNode(int nodeId, int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.node", "node");
        criteria.createAlias("ipInterface.snmpInterface", "snmpInterface", 1);
        criteria.createAlias("serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        return NetworkElementFactory.getServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    private static Service[] getServiceArray(List<OnmsMonitoredService> monSvcs) {
        LinkedList<Service> svcs = new LinkedList<Service>();
        for (OnmsMonitoredService monSvc : monSvcs) {
            Service service = new Service(monSvc);
            svcs.add(service);
        }
        return svcs.toArray(new Service[svcs.size()]);
    }

    @Override
    public String getServiceNameFromId(int serviceId) {
        OnmsServiceType type = (OnmsServiceType)this.m_serviceTypeDao.get((Serializable)Integer.valueOf(serviceId));
        return type == null ? null : type.getName();
    }

    @Override
    public int getServiceIdFromName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsServiceType type = this.m_serviceTypeDao.findByName(serviceName);
        return type == null ? -1 : type.getId();
    }

    @Override
    public Map<Integer, String> getServiceIdToNameMap() {
        HashMap<Integer, String> serviceMap = new HashMap<Integer, String>();
        for (OnmsServiceType type : this.m_serviceTypeDao.findAll()) {
            serviceMap.put(type.getId(), type.getName());
        }
        return serviceMap;
    }

    @Override
    public Map<String, Integer> getServiceNameToIdMap() {
        HashMap<String, Integer> serviceMap = new HashMap<String, Integer>();
        for (OnmsServiceType type : this.m_serviceTypeDao.findAll()) {
            serviceMap.put(type.getName(), type.getId());
        }
        return serviceMap;
    }

    @Override
    public List<OnmsNode> getNodesLikeAndIpLike(String nodeLabel, String iplike, int serviceId) {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createAlias("assetRecord", "assetRecord");
        nodeCrit.add(Restrictions.ilike((String)"label", (Object)nodeLabel));
        nodeCrit.createCriteria("ipInterfaces").add(OnmsRestrictions.ipLike((String)iplike)).createAlias("monitoredServices", "monSvcs").createAlias("monSvcs.serviceType", "serviceType").add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        nodeCrit.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getNodesLike(String nodeLabel, int serviceId) {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("ipInterfaces", "iface");
        criteria.createAlias("iface.monitoredServices", "monSvcs");
        criteria.createAlias("monSvcs.serviceType", "serviceType");
        criteria.add(Restrictions.ilike((String)"label", (String)nodeLabel, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIpLike(String iplike, int serviceId) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createAlias("assetRecord", "assetRecord");
        nodeCrit.createCriteria("ipInterfaces", "iface").createAlias("monitoredServices", "monSvcs").createAlias("monSvcs.serviceType", "serviceType").add(OnmsRestrictions.ipLike((String)iplike)).add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.addOrder(Order.asc((String)"label"));
        nodeCrit.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getAllNodes(int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("ipInterfaces", "ipInterfaces");
        criteria.createAlias("ipInterfaces.monitoredServices", "monSvcs");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add((Criterion)Restrictions.eq((String)"monSvcs.serviceType.id", (Object)serviceId));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesFromPhysaddr(String AtPhysAddr) {
        if (AtPhysAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("arpInterfaces", "arpInterfaces");
        criteria.add(Restrictions.ilike((String)"arpInterfaces.physAddr", (String)AtPhysAddr, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.ne((String)"arpInterfaces.status", (Object)OnmsArpInterface.StatusType.DELETED));
        criteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public AtInterface getAtInterface(int nodeId, String ipAddr) {
        return this.getAtInterfaceForOnmsNode((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId)), ipAddr);
    }

    private AtInterface getAtInterfaceForOnmsNode(OnmsNode onmsNode, String ipAddr) {
        for (OnmsArpInterface iface : onmsNode.getArpInterfaces()) {
            String ifaceAddress = iface.getIpAddress();
            if (ifaceAddress == null || !ifaceAddress.equals(ipAddr)) continue;
            return new AtInterface(iface);
        }
        return null;
    }

    @Override
    public IpRouteInterface[] getIpRoute(int nodeID) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"node.id", (Object)nodeID), (Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED)));
        List<IpRouteInterface> nodes = this.getIpRouteInterfaceArray(this.m_ipRouteInterfaceDao.findMatching(criteria));
        return nodes.toArray(new IpRouteInterface[nodes.size()]);
    }

    private List<IpRouteInterface> getIpRouteInterfaceArray(List<OnmsIpRouteInterface> iproutes) {
        ArrayList<IpRouteInterface> routes = new ArrayList<IpRouteInterface>();
        for (OnmsIpRouteInterface iproute : iproutes) {
            routes.add(new IpRouteInterface(iproute));
        }
        return routes;
    }

    @Override
    public boolean isParentNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        int count = this.m_dataLinkInterfaceDao.countMatching(criteria);
        return count > 0;
    }

    @Override
    public boolean isBridgeNode(int nodeID) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeID));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        int count = this.m_stpNodeDao.countMatching(criteria);
        return count > 0;
    }

    @Override
    public boolean isRouteInfoNode(int nodeID) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeID));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        int count = this.m_ipRouteInterfaceDao.countMatching(criteria);
        return count > 0;
    }

    @Override
    public Set<Integer> getLinkedNodeIdOnNode(int nodeID) {
        Integer linkedNodeId;
        TreeSet<Integer> nodes = new TreeSet<Integer>();
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findByNodeId(Integer.valueOf(nodeID))) {
            linkedNodeId = link.getNodeParentId();
            if (nodes.contains(linkedNodeId) || link.getStatus().equals((Object)OnmsArpInterface.StatusType.DELETED)) continue;
            nodes.add(linkedNodeId);
        }
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findByNodeParentId(Integer.valueOf(nodeID))) {
            linkedNodeId = link.getNodeId();
            if (nodes.contains(linkedNodeId) || link.getStatus().equals((Object)OnmsArpInterface.StatusType.DELETED)) continue;
            nodes.add(linkedNodeId);
        }
        return nodes;
    }

    @Override
    public List<LinkInterface> getDataLinksOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        criteria.addOrder(Order.asc((String)"ifIndex"));
        List<LinkInterface> ifaces = this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId);
        criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        ifaces.addAll(this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId));
        return ifaces;
    }

    @Override
    public List<LinkInterface> getDataLinksOnInterface(int nodeId, String ipAddress) {
        Interface iface = this.getInterface(nodeId, ipAddress);
        if (iface != null && Integer.valueOf(iface.getIfIndex()) != null && iface.getIfIndex() > 0) {
            return this.getDataLinksOnInterface(nodeId, iface.getIfIndex());
        }
        return new ArrayList<LinkInterface>();
    }

    @Override
    public List<LinkInterface> getDataLinksOnInterface(int id) {
        Interface iface = this.getInterface(id);
        if (iface != null && Integer.valueOf(iface.getIfIndex()) != null && iface.getIfIndex() > 0) {
            return this.getDataLinksOnInterface(iface.getNodeId(), iface.getIfIndex());
        }
        return new ArrayList<LinkInterface>();
    }

    @Override
    public List<LinkInterface> getDataLinksOnInterface(int nodeId, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        List<LinkInterface> ifaces = this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId);
        criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"parentIfIndex", (Object)ifIndex));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        criteria.addOrder(Order.asc((String)"parentIfIndex"));
        ifaces.addAll(this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId));
        return ifaces;
    }

    private List<LinkInterface> getDataLinkInterface(List<DataLinkInterface> dlifaces, int nodeId) {
        ArrayList<LinkInterface> lifaces = new ArrayList<LinkInterface>();
        for (DataLinkInterface dliface : dlifaces) {
            if (dliface.getNode().getId() == nodeId) {
                lifaces.add(this.createLinkInterface(dliface, false));
                continue;
            }
            if (dliface.getNodeParentId() != nodeId) continue;
            lifaces.add(this.createLinkInterface(dliface, true));
        }
        return lifaces;
    }

    private LinkInterface createLinkInterface(DataLinkInterface dliface, boolean isParent) {
        Integer nodeid = dliface.getNode().getId();
        Integer ifindex = dliface.getIfIndex();
        Integer linkedNodeid = dliface.getNodeParentId();
        Integer linkedIfindex = dliface.getParentIfIndex();
        if (isParent) {
            nodeid = dliface.getNodeParentId();
            ifindex = dliface.getParentIfIndex();
            linkedNodeid = dliface.getNode().getId();
            linkedIfindex = dliface.getIfIndex();
        }
        Interface iface = this.getInterfaceForLink(nodeid, ifindex);
        Interface linkedIface = this.getInterfaceForLink(linkedNodeid, linkedIfindex);
        return new LinkInterface(dliface, isParent, iface, linkedIface);
    }

    private Interface getInterfaceForLink(int nodeid, int ifindex) {
        Interface iface = null;
        if (ifindex > 0) {
            iface = this.getSnmpInterface(nodeid, ifindex);
            OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
            criteria.add(Restrictions.sqlRestriction((String)("nodeid = " + nodeid + " and ifindex = " + ifindex)));
            ArrayList<String> addresses = new ArrayList<String>();
            for (OnmsIpInterface onmsIpInterface : this.m_ipInterfaceDao.findMatching(criteria)) {
                addresses.add(onmsIpInterface.getIpAddress().getHostAddress());
            }
            if (addresses.size() > 0) {
                if (iface == null) {
                    iface = new Interface();
                    iface.m_nodeId = nodeid;
                    iface.m_ifIndex = ifindex;
                }
                iface.setIpaddresses(addresses);
            } else if (iface != null) {
                iface.setIpaddresses(addresses);
            }
        }
        return iface;
    }

    @Override
    public Vlan[] getVlansOnNode(int nodeID) {
        Criteria criteria = new Criteria(OnmsVlan.class).setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeID)).addRestriction((Restriction)new NeRestriction("status", (Object)OnmsArpInterface.StatusType.DELETED));
        List<Vlan> vlans = this.getVlans(this.m_vlanDao.findMatching(criteria));
        return vlans.toArray(new Vlan[vlans.size()]);
    }

    private List<Vlan> getVlans(List<OnmsVlan> onmsvlans) {
        ArrayList<Vlan> vlans = new ArrayList<Vlan>();
        for (OnmsVlan onmsvlan : onmsvlans) {
            vlans.add(new Vlan(onmsvlan));
        }
        return vlans;
    }

    @Override
    public StpInterface[] getStpInterface(int nodeID) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeID));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        ArrayList<StpInterface> stpinterfaces = new ArrayList<StpInterface>();
        for (OnmsStpInterface onmsStpInterface : this.m_stpInterfaceDao.findMatching(criteria)) {
            stpinterfaces.add(this.getStpInterface(onmsStpInterface));
        }
        return stpinterfaces.toArray(new StpInterface[stpinterfaces.size()]);
    }

    @Override
    public StpInterface[] getStpInterface(int nodeID, int ifindex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeID));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifindex));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        ArrayList<StpInterface> stpinterfaces = new ArrayList<StpInterface>();
        for (OnmsStpInterface onmsStpInterface : this.m_stpInterfaceDao.findMatching(criteria)) {
            stpinterfaces.add(this.getStpInterface(onmsStpInterface));
        }
        return stpinterfaces.toArray(new StpInterface[stpinterfaces.size()]);
    }

    @Override
    public StpNode[] getStpNode(int nodeID) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeID));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        ArrayList<StpNode> nodes = new ArrayList<StpNode>();
        for (OnmsStpNode onmsstpnode : this.m_stpNodeDao.findMatching(criteria)) {
            nodes.add(this.getStpNode(onmsstpnode));
        }
        return nodes.toArray(new StpNode[nodes.size()]);
    }

    private Integer getStpNodeFromStpRootIdentifier(String baseaddress) {
        if (!baseaddress.equals("")) {
            OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
            criteria.add((Criterion)Restrictions.eq((String)"baseBridgeAddress", (Object)baseaddress.substring(5, 16)));
            List stpnodes = this.m_stpNodeDao.findMatching(criteria);
            if (stpnodes.size() == 1) {
                return ((OnmsStpNode)stpnodes.get(0)).getId();
            }
        }
        return null;
    }

    private StpInterface getStpInterface(OnmsStpInterface onmsStpInterface) {
        Integer element;
        StpInterface stpIf = new StpInterface(onmsStpInterface);
        if (stpIf.get_stpdesignatedbridge() != null && (element = this.getStpNodeFromStpRootIdentifier(stpIf.get_stpdesignatedbridge())) != null) {
            stpIf.setStpBridgeNodeid(element);
        }
        return stpIf;
    }

    private StpNode getStpNode(OnmsStpNode node) {
        Integer element;
        StpNode stpNode = new StpNode(node);
        if (node.getStpDesignatedRoot() != null && (element = this.getStpNodeFromStpRootIdentifier(node.getStpDesignatedRoot())) != null) {
            stpNode.m_stprootnodeid = element;
        }
        return stpNode;
    }

    @Transactional
    private String getIpAddress(int nodeid, int ifindex) {
        String retval = null;
        OnmsSnmpInterface snmpinterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifindex));
        for (OnmsIpInterface ipinterface : snmpinterface.getIpInterfaces()) {
            retval = ipinterface.getIpAddress().getHostAddress();
        }
        return retval;
    }

    @Override
    public List<Integer> getNodeIdsWithIpLike(String iplike) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createCriteria("ipInterfaces", "iface").add(OnmsRestrictions.ipLike((String)iplike));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        List nodes = this.m_nodeDao.findMatching(nodeCrit);
        for (OnmsNode node : nodes) {
            nodeIds.add(node.getId());
        }
        return nodeIds;
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(TransactionTemplate transTemplate, final String[] categories1, final boolean onlyNodesWithDownAggregateStatus) {
        return (List)transTemplate.execute((TransactionCallback)new TransactionCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInTransaction(TransactionStatus arg0) {
                return NetworkElementFactory.this.getNodesWithCategories(categories1, onlyNodesWithDownAggregateStatus);
            }
        });
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(String[] categories, boolean onlyNodesWithDownAggregateStatus) {
        List<OnmsNode> ourNodes = this.getNodesInCategories(categories);
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(new HashSet<OnmsNode>(ourNodes));
            ourNodes = as.getDownNodes();
        }
        return ourNodes;
    }

    private List<OnmsNode> getNodesInCategories(String[] categoryStrings) {
        ArrayList<OnmsCategory> categories = new ArrayList<OnmsCategory>();
        for (String categoryString : categoryStrings) {
            OnmsCategory category = this.m_categoryDao.findByName(categoryString);
            if (category == null) {
                throw new IllegalArgumentException("The Category " + categoryString + " does not exist");
            }
            categories.add(category);
        }
        return this.m_nodeDao.findAllByCategoryList(categories);
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(TransactionTemplate transTemplate, final String[] categories1, final String[] categories2, final boolean onlyNodesWithDownAggregateStatus) {
        return (List)transTemplate.execute((TransactionCallback)new TransactionCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInTransaction(TransactionStatus status) {
                return NetworkElementFactory.this.getNodesWithCategories(categories1, categories2, onlyNodesWithDownAggregateStatus);
            }
        });
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(String[] categories1, String[] categories2, boolean onlyNodesWithDownAggregateStatus) {
        ArrayList<OnmsCategory> c1 = new ArrayList<OnmsCategory>(categories1.length);
        for (String category : categories1) {
            c1.add(this.m_categoryDao.findByName(category));
        }
        ArrayList<OnmsCategory> c2 = new ArrayList<OnmsCategory>(categories2.length);
        for (String category : categories2) {
            c2.add(this.m_categoryDao.findByName(category));
        }
        List<OnmsNode> ourNodes1 = this.getNodesInCategories(categories1);
        List<OnmsNode> ourNodes2 = this.getNodesInCategories(categories2);
        HashSet<Integer> n2id = new HashSet<Integer>(ourNodes2.size());
        for (OnmsNode n2 : ourNodes2) {
            n2id.add(n2.getId());
        }
        List<OnmsNode> ourNodes = new ArrayList<OnmsNode>();
        for (OnmsNode n1 : ourNodes1) {
            if (!n2id.contains(n1.getId())) continue;
            ourNodes.add(n1);
        }
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(ourNodes);
            ourNodes = as.getDownNodes();
        }
        return ourNodes;
    }

    private Interface[] getInterfaceArray(List<OnmsIpInterface> ipIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsIpInterface iface : ipIfaces) {
            intfs.add(new Interface(iface));
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    private Interface[] getInterfaceArrayWithSnmpData(List<OnmsIpInterface> ipIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsIpInterface iface : ipIfaces) {
            Interface intf = new Interface(iface);
            if (iface.getSnmpInterface() != null) {
                OnmsSnmpInterface snmpIface = iface.getSnmpInterface();
                intf.createSnmpInterface(snmpIface);
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    public static class InterfaceComparator
    implements Comparator<Interface> {
        @Override
        public int compare(Interface o1, Interface o2) {
            if (!"0.0.0.0".equals(o1.getIpAddress()) && !"0.0.0.0".equals(o2.getIpAddress())) {
                return new InetAddressComparator().compare(InetAddressUtils.addr((String)o1.getIpAddress()), InetAddressUtils.addr((String)o2.getIpAddress()));
            }
            if (!"0.0.0.0".equals(o1.getIpAddress())) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2.getIpAddress())) {
                return 1;
            }
            return 0;
        }
    }
}

