/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.web.api.Util;
import org.opennms.web.element.Interface;

public class LinkInterface {
    private final Interface m_iface;
    private final Interface m_linkedInterface;
    private final String m_lastPollTime;
    private final String m_status;
    private final String m_protocol;
    private final Integer m_linktypeid;
    private final Integer m_nodeId;
    private final Integer m_ifindex;
    private final Integer m_linkedNodeId;
    private final Integer m_linkedIfindex;
    private static final Map<Integer, String> linktypeMap = new HashMap<Integer, String>();

    LinkInterface(DataLinkInterface dl, boolean isParent, Interface iface, Interface linkedIface) {
        if (isParent) {
            this.m_nodeId = dl.getNodeParentId();
            this.m_ifindex = dl.getParentIfIndex();
            this.m_linkedNodeId = dl.getNodeId();
            this.m_linkedIfindex = dl.getIfIndex();
        } else {
            this.m_nodeId = dl.getNodeId();
            this.m_ifindex = dl.getIfIndex();
            this.m_linkedNodeId = dl.getNodeParentId();
            this.m_linkedIfindex = dl.getParentIfIndex();
        }
        this.m_iface = iface;
        this.m_linkedInterface = linkedIface;
        this.m_lastPollTime = Util.formatDateToUIString((Date)dl.getLastPollTime());
        this.m_status = OnmsArpInterface.StatusType.getStatusString((char)dl.getStatus().getCharCode());
        this.m_linktypeid = dl.getLinkTypeId();
        this.m_protocol = dl.getProtocol() == null ? "&nbsp" : dl.getProtocol().toString();
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_iface.getNodeId() + "\n");
        str.append("IfIndex = " + this.m_iface.getIfIndex() + "\n");
        str.append("Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Link Type Id = " + this.m_linktypeid + "\n");
        str.append("Status= " + this.m_status + "\n");
        return str.toString();
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public Integer getIfindex() {
        return this.m_ifindex;
    }

    public Integer getLinkedNodeId() {
        return this.m_linkedNodeId;
    }

    public Integer getLinkedIfindex() {
        return this.m_linkedIfindex;
    }

    public String getLastPollTime() {
        return this.m_lastPollTime;
    }

    public String getStatus() {
        return this.m_status;
    }

    public Integer getLinktypeId() {
        return this.m_linktypeid;
    }

    public String getLinkTypeIdString() {
        if (linktypeMap.containsKey(this.m_linktypeid)) {
            return linktypeMap.get(this.m_linktypeid);
        }
        return null;
    }

    public Interface getLinkedInterface() {
        return this.m_linkedInterface;
    }

    public Interface getInterface() {
        return this.m_iface;
    }

    public boolean hasInterface() {
        return this.m_iface != null;
    }

    public boolean hasLinkedInterface() {
        return this.m_linkedInterface != null;
    }

    static {
        linktypeMap.put(9999, "Unknown");
        linktypeMap.put(777, "DWO connection");
        linktypeMap.put(1777, "Summary Link");
    }
}

