/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.Date;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.web.api.Util;
import org.opennms.web.element.ElementUtil;

public class IpRouteInterface {
    int m_nodeId;
    int m_routeifindex;
    int m_routemetric1;
    int m_routemetric2;
    int m_routemetric3;
    int m_routemetric4;
    int m_routemetric5;
    String m_routetype;
    String m_routeproto;
    String m_routedest;
    String m_routemask;
    String m_routenexthop;
    String m_lastPollTime;
    String m_status;

    IpRouteInterface() {
    }

    IpRouteInterface(OnmsIpRouteInterface iproute) {
        this.m_nodeId = iproute.getNode().getId();
        this.m_routeifindex = iproute.getRouteIfIndex();
        this.m_routemetric1 = iproute.getRouteMetric1();
        this.m_routemetric2 = iproute.getRouteMetric2();
        this.m_routemetric3 = iproute.getRouteMetric3();
        this.m_routemetric4 = iproute.getRouteMetric4();
        this.m_routemetric5 = iproute.getRouteMetric5();
        this.m_routetype = OnmsIpRouteInterface.RouteType.getRouteTypeString((Integer)iproute.getRouteType().getIntCode());
        this.m_routeproto = ElementUtil.getIpRouteProtocolString(iproute.getRouteProto());
        this.m_routenexthop = iproute.getRouteNextHop();
        this.m_routedest = iproute.getRouteDest();
        this.m_routemask = iproute.getRouteMask();
        this.m_lastPollTime = Util.formatDateToUIString((Date)iproute.getLastPollTime());
        this.m_status = OnmsArpInterface.StatusType.getStatusString((char)iproute.getStatus().getCharCode());
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public int get_ifindex() {
        return this.m_routeifindex;
    }

    public String get_lastPollTime() {
        return this.m_lastPollTime;
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public String get_status() {
        return this.m_status;
    }

    public String get_routedest() {
        return this.m_routedest;
    }

    public String get_routemask() {
        return this.m_routemask;
    }

    public int get_routemetric1() {
        return this.m_routemetric1;
    }

    public int get_routemetric2() {
        return this.m_routemetric2;
    }

    public int get_routemetric3() {
        return this.m_routemetric3;
    }

    public int get_routemetric4() {
        return this.m_routemetric4;
    }

    public int get_routemetric5() {
        return this.m_routemetric5;
    }

    public String get_routenexthop() {
        return this.m_routenexthop;
    }

    public String get_routeproto() {
        return this.m_routeproto;
    }

    public String get_routetype() {
        return this.m_routetype;
    }
}

