/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import org.opennms.netmgt.model.OnmsArpInterface;

public class AtInterface {
    private final int m_nodeId;
    private final int m_sourcenodeid;
    private final int m_ifindex;
    private final String m_ipaddr;
    private final String m_physaddr;
    private final String m_lastPollTime;
    private final String m_status;

    AtInterface(OnmsArpInterface iface) {
        this.m_nodeId = iface.getNode().getId();
        this.m_sourcenodeid = iface.getSourceNode().getId();
        this.m_ifindex = iface.getIfIndex();
        this.m_ipaddr = iface.getIpAddress();
        this.m_physaddr = iface.getPhysAddr();
        this.m_lastPollTime = iface.getLastPoll().toString();
        this.m_status = OnmsArpInterface.StatusType.getStatusString((char)iface.getStatus().getCharCode());
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Node Source = " + this.m_sourcenodeid + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Dp name = " + this.m_physaddr + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public int get_ifindex() {
        return this.m_ifindex;
    }

    public String get_ipaddr() {
        return this.m_ipaddr;
    }

    public String get_lastPollTime() {
        return this.m_lastPollTime;
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public String get_physaddr() {
        return this.m_physaddr;
    }

    public int get_sourcenodeid() {
        return this.m_sourcenodeid;
    }

    public String get_status() {
        return this.m_status;
    }
}

