/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.event.Event;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdListFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.NoticeQueryParms;
import org.opennms.web.notification.NoticeUtil;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.SortStyle;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class NotificationFilterController
extends AbstractController
implements InitializingBean {
    public static final int DEFAULT_MULTIPLE = 0;
    private String m_successView;
    private Integer m_defaultShortLimit;
    private Integer m_defaultLongLimit;
    private SortStyle m_defaultSortStyle = SortStyle.ID;
    private AcknowledgeType m_defaultAckType = AcknowledgeType.UNACKNOWLEDGED;
    private WebEventRepository m_webEventRepository;
    private WebNotificationRepository m_webNotificationRepository;
    private NodeDao m_nodeDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Filter filter;
        String username;
        AcknowledgeType temp;
        SortStyle temp2;
        String display = request.getParameter("display");
        String sortStyleString = request.getParameter("sortby");
        SortStyle sortStyle = this.m_defaultSortStyle;
        if (sortStyleString != null && (temp2 = SortStyle.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp2;
        }
        String ackTypeString = request.getParameter("acktype");
        AcknowledgeType ackType = this.m_defaultAckType;
        if (ackTypeString != null && (temp = AcknowledgeType.getAcknowledgeType(ackTypeString)) != null) {
            ackType = temp;
        }
        String[] filterStrings = request.getParameterValues("filter");
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (String filterString : filterStrings) {
                Filter filter2 = NoticeUtil.getFilter(filterString, this.getServletContext());
                if (filter2 == null) continue;
                filterList.add(filter2);
            }
        }
        if ((username = request.getParameter("user")) != null && (filter = NoticeUtil.getFilter("user=" + username, this.getServletContext())) != null) {
            filterList.add(filter);
        }
        String limitString = request.getParameter("limit");
        int limit = "long".equals(display) ? this.m_defaultLongLimit : this.m_defaultShortLimit;
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String multipleString = request.getParameter("multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Filter[] filters = filterList.toArray(new Filter[0]);
        NoticeQueryParms parms = new NoticeQueryParms();
        parms.ackType = ackType;
        parms.display = display;
        parms.filters = filterList;
        parms.limit = limit;
        parms.multiple = multiple;
        parms.sortStyle = sortStyle;
        NotificationCriteria queryCriteria = new NotificationCriteria(filters, sortStyle, ackType, limit, limit * multiple);
        NotificationCriteria countCriteria = new NotificationCriteria(ackType, filters);
        Notification[] notices = this.m_webNotificationRepository.getMatchingNotifications(queryCriteria);
        int noticeCount = this.m_webNotificationRepository.countMatchingNotifications(countCriteria);
        HashMap<Integer, String[]> nodeLabels = new HashMap<Integer, String[]>();
        TreeSet<Integer> eventIds = new TreeSet<Integer>();
        for (Notification notice : notices) {
            eventIds.add(notice.getEventId());
            if (nodeLabels.containsKey(notice.getNodeId())) continue;
            String[] labels = null;
            OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(notice.getNodeId()));
            if (node != null) {
                String longLabel = node.getLabel();
                if (longLabel == null) {
                    labels = new String[]{"&lt;No Node Label&gt;", "&lt;No Node Label&gt;"};
                } else if (longLabel.length() > 32) {
                    String shortLabel = longLabel.substring(0, 31) + "...";
                    labels = new String[]{shortLabel, longLabel};
                } else {
                    labels = new String[]{longLabel, longLabel};
                }
            }
            nodeLabels.put(notice.getNodeId(), labels);
        }
        HashMap<Integer, Event> events = new HashMap<Integer, Event>();
        if (eventIds.size() > 0) {
            for (Event e : this.m_webEventRepository.getMatchingEvents(new EventCriteria(new EventIdListFilter(eventIds)))) {
                events.put(e.getId(), e);
            }
        }
        ModelAndView modelAndView = new ModelAndView(this.m_successView);
        modelAndView.addObject("notices", (Object)notices);
        modelAndView.addObject("noticeCount", (Object)noticeCount);
        modelAndView.addObject("nodeLabels", nodeLabels);
        modelAndView.addObject("events", events);
        modelAndView.addObject("parms", (Object)parms);
        return modelAndView;
    }

    public void setDefaultShortLimit(Integer limit) {
        this.m_defaultShortLimit = limit;
    }

    public void setDefaultLongLimit(Integer limit) {
        this.m_defaultLongLimit = limit;
    }

    public void setDefaultSortStyle(SortStyle sortStyle) {
        this.m_defaultSortStyle = sortStyle;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebEventRepository(WebEventRepository webEventRepository) {
        this.m_webEventRepository = webEventRepository;
    }

    public void setWebNotificationRepository(WebNotificationRepository webNotificationRepository) {
        this.m_webNotificationRepository = webNotificationRepository;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_defaultShortLimit, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultShortLimit > 0 ? 1 : 0) != 0, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_defaultLongLimit, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.isTrue((this.m_defaultLongLimit > 0 ? 1 : 0) != 0, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webNotificationRepository, (String)"webNotificationRepository must be set");
        Assert.notNull((Object)this.m_webEventRepository, (String)"webEventRepository must be set");
        Assert.notNull((Object)this.m_nodeDao, (String)"nodeDao must be set");
    }
}

