/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.web.controller.ksc.KscReportEditor;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.KscReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcViewController
extends AbstractController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FormProcViewController.class);
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int reportId = -1;
        String overrideTimespan = null;
        String overrideGraphType = null;
        String reportAction = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.action.toString()));
        String reportIdString = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.report.toString()));
        String reportType = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.type.toString()));
        if (reportAction == null) {
            throw new MissingParameterException("action", new String[]{"action", "report", "type"});
        }
        if (reportType == null) {
            throw new MissingParameterException("type", new String[]{"action", "report", "type"});
        }
        if (reportIdString == null) {
            throw new MissingParameterException("report", new String[]{"action", "report", "type"});
        }
        if (Actions.Customize.toString().equals(reportAction) || Actions.Update.toString().equals(reportAction)) {
            if (reportType.equals("node") || reportType.equals("custom")) {
                reportId = WebSecurityUtils.safeParseInt((String)reportIdString);
            }
            if ((overrideTimespan = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.timespan.toString()))) == null || overrideTimespan.equals("null")) {
                overrideTimespan = "none";
            }
            if ((overrideGraphType = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graphtype.toString()))) == null || overrideGraphType.equals("null")) {
                overrideGraphType = "none";
            }
            if (Actions.Customize.toString().equals(reportAction)) {
                KscReportEditor editor = KscReportEditor.getFromSession(request.getSession(), false);
                LOG.debug("handleRequestInternal: build report for reportType {}", (Object)reportType);
                if (reportType.equals("node")) {
                    editor.loadWorkingReport(this.m_kscReportService.buildNodeReport(reportId));
                } else if (reportType.equals("nodeSource")) {
                    editor.loadWorkingReport(this.m_kscReportService.buildNodeSourceReport(reportIdString));
                } else if (reportType.equals("domain")) {
                    editor.loadWorkingReport(this.m_kscReportService.buildDomainReport(reportIdString));
                } else {
                    editor.loadWorkingReport(this.getKscReportFactory(), reportId);
                }
                Report working_report = editor.getWorkingReport();
                for (int i = 0; i < working_report.getGraphCount(); ++i) {
                    Graph working_graph = working_report.getGraph(i);
                    if (!overrideTimespan.equals("none")) {
                        working_graph.setTimespan(overrideTimespan);
                    }
                    if (overrideGraphType.equals("none")) continue;
                    working_graph.setGraphtype(overrideGraphType);
                }
            }
        } else if (!Actions.Exit.toString().equals(reportAction)) {
            throw new ServletException("Invalid Parameter contents for report_action");
        }
        if (Actions.Update.toString().equals(reportAction)) {
            ModelAndView modelAndView = new ModelAndView("redirect:/KSC/customView.htm");
            modelAndView.addObject("type", (Object)reportType);
            if (reportIdString != null) {
                modelAndView.addObject("report", (Object)reportIdString);
            }
            if (overrideTimespan != null) {
                modelAndView.addObject("timespan", (Object)overrideTimespan);
            }
            if (overrideGraphType != null) {
                modelAndView.addObject("graphtype", (Object)overrideGraphType);
            }
            return modelAndView;
        }
        if (Actions.Customize.toString().equals(reportAction)) {
            return new ModelAndView("redirect:/KSC/customReport.htm");
        }
        if (Actions.Exit.toString().equals(reportAction)) {
            return new ModelAndView("redirect:/KSC/index.htm");
        }
        throw new IllegalArgumentException("Parameter action of '" + reportAction + "' is not supported.  Must be one of: Update, Customize, or Exit");
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public static enum Actions {
        Customize,
        Update,
        Exit;

    }

    public static enum Parameters {
        action,
        timespan,
        type,
        report,
        graphtype;

    }
}

