/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.inventory;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.controller.inventory.AdminRancidRouterDbCommClass;
import org.opennms.web.svclayer.inventory.InventoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class AdminRancidUpdateController
extends SimpleFormController {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRancidUpdateController.class);
    InventoryService m_inventoryService;

    public InventoryService getInventoryService() {
        return this.m_inventoryService;
    }

    public void setInventoryService(InventoryService inventoryService) {
        this.m_inventoryService = inventoryService;
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws ServletException, IOException, Exception {
        boolean done;
        LOG.debug("AdminRancidUpdateController ModelAndView onSubmit");
        AdminRancidRouterDbCommClass bean = (AdminRancidRouterDbCommClass)command;
        LOG.debug("AdminRancidUpdateController ModelAndView onSubmit updating device[{}] group[{}] status[{}]", new Object[]{bean.getDeviceName(), bean.getGroupName(), bean.getStatusName()});
        if (request.isUserInRole("ROLE_ADMIN") && !(done = this.m_inventoryService.updateNodeOnRouterDb(bean.getGroupName(), bean.getDeviceName(), bean.getDeviceTypeName(), bean.getStatusName(), bean.getComment()))) {
            LOG.debug("AdminRancidUpdateController ModelAndView onSubmit error while updating status for{}/{}", (Object)bean.getGroupName(), (Object)bean.getDeviceName());
        }
        String redirectURL = request.getHeader("Referer");
        response.sendRedirect(redirectURL);
        return super.onSubmit(request, response, command, errors);
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        LOG.debug("AdminRancidUpdateController initBinder");
    }
}

