/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.AlarmQueryParms;
import org.opennms.web.alarm.AlarmUtil;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alert.AlertType;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.FilterUtil;
import org.opennms.web.filter.NormalizedQueryParameters;
import org.opennms.web.services.FilterFavoriteService;
import org.opennms.web.tags.AlertTag;
import org.opennms.web.tags.filters.AlarmFilterCallback;
import org.opennms.web.tags.filters.FilterCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class AlarmFilterController
extends MultiActionController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmFilterController.class);
    private static final int DEFAULT_MULTIPLE = 0;
    private static final int DEFAULT_SHORT_LIMIT = 20;
    private static final int DEFAULT_LONG_LIMIT = 10;
    private static final AcknowledgeType DEFAULT_ACKNOWLEDGE_TYPE = AcknowledgeType.UNACKNOWLEDGED;
    private static final SortStyle DEFAULT_SORT_STYLE = SortStyle.ID;
    @Autowired
    private AlarmRepository m_webAlarmRepository;
    @Autowired
    private FilterFavoriteService favoriteService;
    private FilterCallback m_callback;

    @Transactional
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    public ModelAndView list(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OnmsFilterFavorite favorite = this.getFavorite(request.getParameter("favoriteId"), request.getRemoteUser(), request.getParameterValues("filter"));
        return this.list(request, favorite);
    }

    private ModelAndView list(HttpServletRequest request, OnmsFilterFavorite favorite) {
        AcknowledgeType ackType = this.getAcknowledgeType(request);
        ModelAndView modelAndView = this.createListModelAndView(request, this.getFilterCallback().parse(request.getParameterValues("filter")), ackType);
        modelAndView.addObject("favorite", (Object)favorite);
        modelAndView.setViewName("alarm/list");
        return modelAndView;
    }

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<OnmsFilterFavorite> userFilterList = this.favoriteService.getFavorites(request.getRemoteUser(), OnmsFilterFavorite.Page.ALARM);
        ModelAndView modelAndView = new ModelAndView("alarm/index");
        modelAndView.addObject("favorites", (Object)userFilterList.toArray());
        modelAndView.addObject("callback", (Object)this.getFilterCallback());
        return modelAndView;
    }

    public ModelAndView createFavorite(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String error = null;
        try {
            OnmsFilterFavorite favorite = this.favoriteService.createFavorite(request.getRemoteUser(), request.getParameter("favoriteName"), FilterUtil.toFilterURL(request.getParameterValues("filter")), OnmsFilterFavorite.Page.ALARM);
            if (favorite != null) {
                ModelAndView successView = this.list(request, favorite);
                return successView;
            }
            error = "An error occured while creating the favorite";
        }
        catch (FilterFavoriteService.FilterFavoriteException ex) {
            error = ex.getMessage();
        }
        ModelAndView errorView = this.list(request, (OnmsFilterFavorite)null);
        AlertTag.addAlertToRequest(errorView, error, AlertType.ERROR);
        return errorView;
    }

    public ModelAndView deleteFavorite(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String favoriteId = request.getParameter("favoriteId");
        boolean success = this.favoriteService.deleteFavorite(favoriteId, request.getRemoteUser());
        ModelAndView resultView = this.list(request, (OnmsFilterFavorite)null);
        resultView.addObject("favorite", null);
        if (!StringUtils.isEmpty((String)request.getParameter("redirect"))) {
            resultView.setViewName(request.getParameter("redirect"));
        }
        if (!success) {
            AlertTag.addAlertToRequest(resultView, "Favorite couldn't be deleted.", AlertType.ERROR);
        } else {
            AlertTag.addAlertToRequest(resultView, "Favorite deleted successfully.", AlertType.SUCCESS);
        }
        return resultView;
    }

    private String getDisplay(HttpServletRequest request) {
        return request.getParameter("display");
    }

    private int getLimit(HttpServletRequest request) {
        int limit;
        String display = this.getDisplay(request);
        String limitString = request.getParameter("limit");
        int n = limit = "long".equals(display) ? 10 : 20;
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return limit;
    }

    private int getMultiple(HttpServletRequest request) {
        String multipleString = request.getParameter("multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return multiple;
    }

    private SortStyle getSortStyle(HttpServletRequest request) {
        SortStyle temp;
        String sortStyleString = request.getParameter("sortby");
        SortStyle sortStyle = DEFAULT_SORT_STYLE;
        if (sortStyleString != null && (temp = SortStyle.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp;
        }
        return sortStyle;
    }

    private AcknowledgeType getAcknowledgeType(HttpServletRequest request) {
        AcknowledgeType temp;
        String ackTypeString = request.getParameter("acktype");
        AcknowledgeType ackType = DEFAULT_ACKNOWLEDGE_TYPE;
        if (ackTypeString != null && (temp = AcknowledgeType.getAcknowledgeType(ackTypeString)) != null) {
            ackType = temp;
        }
        return ackType;
    }

    private AlarmQueryParms createAlarmQueryParms(HttpServletRequest request, List<Filter> filterList, AcknowledgeType ackType) {
        AlarmQueryParms parms = new AlarmQueryParms();
        parms.ackType = ackType;
        parms.display = this.getDisplay(request);
        parms.filters = filterList;
        parms.limit = this.getLimit(request);
        parms.multiple = this.getMultiple(request);
        parms.sortStyle = this.getSortStyle(request);
        return parms;
    }

    private ModelAndView createListModelAndView(HttpServletRequest request, List<Filter> filterList, AcknowledgeType ackType) {
        AlarmQueryParms parms = this.createAlarmQueryParms(request, filterList, ackType);
        AlarmCriteria queryCriteria = new AlarmCriteria(parms);
        AlarmCriteria countCriteria = new AlarmCriteria(filterList, ackType);
        OnmsAlarm[] alarms = this.m_webAlarmRepository.getMatchingAlarms(AlarmUtil.getOnmsCriteria(queryCriteria));
        long alarmCount = this.m_webAlarmRepository.countMatchingAlarms(AlarmUtil.getOnmsCriteria(countCriteria));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("alarms", (Object)alarms);
        modelAndView.addObject("alarmCount", (Object)alarmCount);
        modelAndView.addObject("parms", (Object)new NormalizedQueryParameters(parms));
        modelAndView.addObject("callback", (Object)this.getFilterCallback());
        modelAndView.addObject("favorites", (Object)this.favoriteService.getFavorites(request.getRemoteUser(), OnmsFilterFavorite.Page.ALARM).toArray());
        return modelAndView;
    }

    private OnmsFilterFavorite getFavorite(String favoriteId, String username, String[] filters) {
        if (favoriteId != null) {
            OnmsFilterFavorite filter = this.favoriteService.getFavorite(favoriteId, username, this.getFilterCallback().toFilterString(filters));
            return filter;
        }
        return null;
    }

    private FilterCallback getFilterCallback() {
        if (this.m_callback == null) {
            this.m_callback = new AlarmFilterCallback(this.getServletContext());
        }
        return this.m_callback;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)20, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.isTrue((boolean)true, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.notNull((Object)10, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.isTrue((boolean)true, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }
}

