/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AlarmBoxController
extends AbstractController
implements InitializingBean {
    public static final int ROWS = 16;
    private AlarmRepository m_webAlarmRepository;
    private String m_successView;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int rows = Integer.getInteger("opennms.nodesWithProblems.count", 16);
        String parm = request.getParameter("alarmCount");
        if (parm != null) {
            try {
                rows = Integer.valueOf(parm);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        List summaries = this.m_webAlarmRepository.getCurrentNodeAlarmSummaries();
        int moreCount = summaries.size() - rows;
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        if (rows == 0 || summaries.size() < rows) {
            modelAndView.addObject("summaries", (Object)summaries);
        } else {
            modelAndView.addObject("summaries", summaries.subList(0, rows));
        }
        modelAndView.addObject("moreCount", (Object)moreCount);
        return modelAndView;
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setAlarmRepository(AlarmRepository webAlarmRepository) {
        this.m_webAlarmRepository = webAlarmRepository;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }
}

