/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.group;

import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.web.group.WebGroup;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class UpdateGroupController
extends AbstractController
implements InitializingBean {
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession userSession = request.getSession(false);
        if (userSession != null) {
            WebGroup newGroup = (WebGroup)userSession.getAttribute("group.modifyGroup.jsp");
            String[] users = request.getParameterValues("selectedUsers");
            newGroup.setUsers(new ArrayList<String>(Arrays.asList(users)));
            String[] selectedCategories = request.getParameterValues("selectedCategories");
            newGroup.setAuthorizedCategories(new ArrayList<String>(Arrays.asList(selectedCategories)));
            Vector<Object> newSchedule = new Vector<Object>();
            ChoiceFormat days = new ChoiceFormat("0#Mo|1#Tu|2#We|3#Th|4#Fr|5#Sa|6#Su");
            List<String> dutySchedules = newGroup.getDutySchedules();
            dutySchedules.clear();
            int dutyCount = WebSecurityUtils.safeParseInt((String)request.getParameter("dutySchedules"));
            for (int duties = 0; duties < dutyCount; ++duties) {
                newSchedule.clear();
                String deleteFlag = request.getParameter("deleteDuty" + duties);
                if (deleteFlag != null) continue;
                for (int i = 0; i < 7; ++i) {
                    String curDayFlag = request.getParameter("duty" + duties + days.format(i));
                    if (curDayFlag != null) {
                        newSchedule.addElement(Boolean.TRUE);
                        continue;
                    }
                    newSchedule.addElement(Boolean.FALSE);
                }
                newSchedule.addElement(request.getParameter("duty" + duties + "Begin"));
                newSchedule.addElement(request.getParameter("duty" + duties + "End"));
                DutySchedule newDuty = new DutySchedule(newSchedule);
                dutySchedules.add(newDuty.toString());
            }
            userSession.setAttribute("group.modifyGroup.jsp", (Object)newGroup);
        }
        return new ModelAndView(request.getParameter("redirect"));
    }

    private String[] removeAll(String[] a, String[] b) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(a));
        list.removeAll(Arrays.asList(b));
        return list.toArray(new String[list.size()]);
    }

    public void afterPropertiesSet() throws Exception {
    }
}

