/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.svclayer.ProgressMonitor;
import org.opennms.web.svclayer.SimpleWebTable;
import org.opennms.web.svclayer.SurveillanceService;
import org.opennms.web.svclayer.SurveillanceViewError;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SurveillanceViewController
extends AbstractController
implements InitializingBean {
    private static final String VIEW_NAME_PARAMETER = "viewName";
    private static final String PROGRESS_MONITOR_KEY = "surveillanceViewProgressMonitor";
    private SurveillanceService m_service;

    public void setService(SurveillanceService svc) {
        this.m_service = svc;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_service != null ? 1 : 0) != 0, (String)"service property must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (!this.m_service.isViewName(req.getParameter(VIEW_NAME_PARAMETER))) {
            SurveillanceViewError viewError = this.createSurveillanceViewError(WebSecurityUtils.sanitizeString((String)req.getParameter(VIEW_NAME_PARAMETER)));
            return new ModelAndView("surveillanceViewError", "error", (Object)viewError);
        }
        HttpSession session = req.getSession();
        resp.setHeader("Refresh", this.m_service.getHeaderRefreshSeconds(WebSecurityUtils.sanitizeString((String)req.getParameter(VIEW_NAME_PARAMETER))));
        ProgressMonitor progressMonitor = (ProgressMonitor)session.getAttribute(PROGRESS_MONITOR_KEY);
        if (progressMonitor == null) {
            progressMonitor = this.createProgressMonitor(WebSecurityUtils.sanitizeString((String)req.getParameter(VIEW_NAME_PARAMETER)));
            session.setAttribute(PROGRESS_MONITOR_KEY, (Object)progressMonitor);
        }
        if (progressMonitor.isError()) {
            session.removeAttribute(PROGRESS_MONITOR_KEY);
            Throwable t = progressMonitor.getThrowable();
            throw new Exception("SurveillanceView Builder Thread threw exception: [" + t.getClass().getName() + "] " + t.getMessage(), t);
        }
        if (progressMonitor.isFinished()) {
            session.removeAttribute(PROGRESS_MONITOR_KEY);
            SimpleWebTable table = (SimpleWebTable)progressMonitor.getResult();
            ModelAndView modelAndView = new ModelAndView("surveillanceView", "webTable", (Object)table);
            modelAndView.addObject("viewNames", this.m_service.getViewNames());
            return modelAndView;
        }
        return new ModelAndView("progressBar", "progress", (Object)progressMonitor);
    }

    private ProgressMonitor createProgressMonitor(final String viewName) {
        final ProgressMonitor monitor = new ProgressMonitor();
        Thread bgRunner = new Thread("SurveillanceView Builder"){

            @Override
            public void run() {
                try {
                    SurveillanceViewController.this.m_service.createSurveillanceTable(viewName, monitor);
                }
                catch (Throwable t) {
                    monitor.errorOccurred(t);
                }
            }
        };
        bgRunner.start();
        ProgressMonitor progressMonitor = monitor;
        return progressMonitor;
    }

    private SurveillanceViewError createSurveillanceViewError(String viewName) {
        SurveillanceViewError viewError = new SurveillanceViewError();
        if (viewName == null) {
            viewError.setShortDescr("No default view");
            viewError.setLongDescr("No view name was specified, and no default view exists in the system.");
        } else {
            viewError.setShortDescr("No such view");
            viewError.setLongDescr("The requested view '" + viewName + "' does not exist in the system.");
        }
        return viewError;
    }
}

