/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.web.api.OnmsHeaderProvider;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.NavBarEntry;
import org.opennms.web.navigate.NavBarModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class NavBarController
extends AbstractController
implements InitializingBean,
OnmsHeaderProvider {
    private List<NavBarEntry> m_navBarItems;

    public void afterPropertiesSet() {
        Assert.state((this.m_navBarItems != null ? 1 : 0) != 0, (String)"navBarItems property has not been set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("navBar", "model", (Object)this.createNavBarModel(request));
    }

    private NavBarModel createNavBarModel(HttpServletRequest request) {
        LinkedHashMap<NavBarEntry, DisplayStatus> navBar = new LinkedHashMap<NavBarEntry, DisplayStatus>();
        for (NavBarEntry entry : this.getNavBarItems()) {
            navBar.put(entry, entry.evaluate(request));
        }
        return new NavBarModel(navBar);
    }

    public List<NavBarEntry> getNavBarItems() {
        return this.m_navBarItems;
    }

    public void setNavBarItems(List<NavBarEntry> navBarItems) {
        this.m_navBarItems = navBarItems;
    }

    public String getHeaderHtml(HttpServletRequest request) {
        return this.createHeaderHtml(request);
    }

    private String createHeaderHtml(HttpServletRequest request) {
        return "<div id='header'><h1 id='headerlogo'><a href='index.jsp'><img src=\"../images/logo.png\" alt='OpenNMS Web Console Home'></a></h1><div id='headerinfo'><h2>Topology Map</h2><p align=\"right\" >User: <a href=\"/opennms/account/selfService/index.jsp\" title=\"Account self-service\"><strong>" + request.getRemoteUser() + "</strong></a>" + "&nbsp;(Notices " + this.getNoticeStatus() + " )" + " - <a href=\"opennms/j_spring_security_logout\">Log out</a><br></p>" + "</div>" + "<div id='headernavbarright'>" + "<div class='navbar'>" + this.createNavBarHtml(request) + "</div>" + "</div>" + "<div class='spacer'><!-- --></div>" + "</div><script type='text/javascript'>if (window.location != window.parent.location) { document.getElementById('header').style.display = 'none'; }</script>";
    }

    private String getNoticeStatus() {
        String noticeStatus;
        try {
            noticeStatus = NotifdConfigFactory.getPrettyStatus();
            noticeStatus = "Off".equals(noticeStatus) ? "<b id=\"notificationOff\">Off</b>" : "<b id=\"notificationOn\">On</b>";
        }
        catch (Throwable t) {
            noticeStatus = "<b id=\"notificationOff\">Unknown</b>";
        }
        return noticeStatus;
    }

    private String createNavBarHtml(HttpServletRequest request) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<ul>");
        for (NavBarEntry entry : this.getNavBarItems()) {
            DisplayStatus displayStatus = entry.evaluate(request);
            switch (displayStatus) {
                case DISPLAY_LINK: {
                    strBuilder.append("<li><a href=\"" + entry.getUrl() + "\" >" + entry.getName() + "</a></li>");
                    break;
                }
                case DISPLAY_NO_LINK: {
                    strBuilder.append("<li>" + entry.getName() + "</li>");
                    break;
                }
            }
        }
        strBuilder.append("</ul>");
        return strBuilder.toString();
    }
}

