/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opennms.web.command.ManageReportScheduleCommand;
import org.opennms.web.svclayer.SchedulerService;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class ManageReportScheduleController
extends SimpleFormController {
    private SchedulerService m_reportSchedulerService;
    private int m_pageSize;

    public ManageReportScheduleController() {
        this.setFormView("report/database/manageSchedule");
    }

    public void setReportSchedulerService(SchedulerService schedulerService) {
        this.m_reportSchedulerService = schedulerService;
    }

    public void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
    }

    protected Map<String, Object> referenceData(HttpServletRequest req) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        PagedListHolder pagedListHolder = new PagedListHolder(this.m_reportSchedulerService.getTriggerDescriptions());
        pagedListHolder.setPageSize(this.m_pageSize);
        int page = ServletRequestUtils.getIntParameter((ServletRequest)req, (String)"p", (int)0);
        pagedListHolder.setPage(page);
        data.put("pagedListHolder", pagedListHolder);
        return data;
    }

    protected ModelAndView onSubmit(Object command) throws Exception {
        ManageReportScheduleCommand manageCommand = (ManageReportScheduleCommand)command;
        this.m_reportSchedulerService.removeTriggers(manageCommand.getTriggerNames());
        ModelAndView mav = new ModelAndView(this.getSuccessView());
        return mav;
    }
}

