/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.web.svclayer.ManualProvisioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class EditProvisioningGroupController
extends SimpleFormController {
    private static final Logger LOG = LoggerFactory.getLogger(EditProvisioningGroupController.class);
    private ManualProvisioningService m_provisioningService;

    public void setProvisioningService(ManualProvisioningService provisioningService) {
        this.m_provisioningService = provisioningService;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequestInternal(request, response);
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        TreeCommand treeCmd = (TreeCommand)command;
        String action = treeCmd.getAction();
        if (action == null) {
            return this.doShow(request, response, treeCmd, errors);
        }
        if ("toggleFreeForm".equalsIgnoreCase(action)) {
            Boolean isFreeForm = (Boolean)request.getSession().getAttribute("freeFormEditing");
            if (isFreeForm == null) {
                isFreeForm = false;
            }
            request.getSession().setAttribute("freeFormEditing", (Object)(isFreeForm == false ? 1 : 0));
            return this.doShow(request, response, treeCmd, errors);
        }
        if ("addNode".equalsIgnoreCase(action)) {
            return this.doAddNode(request, response, treeCmd, errors);
        }
        if ("addInterface".equalsIgnoreCase(action)) {
            return this.doAddInterface(request, response, treeCmd, errors);
        }
        if ("addService".equalsIgnoreCase(action)) {
            return this.doAddService(request, response, treeCmd, errors);
        }
        if ("addCategory".equalsIgnoreCase(action)) {
            return this.doAddCategory(request, response, treeCmd, errors);
        }
        if ("addAssetField".equalsIgnoreCase(action)) {
            return this.doAddAssetField(request, response, treeCmd, errors);
        }
        if ("save".equalsIgnoreCase(action)) {
            return this.doSave(request, response, treeCmd, errors);
        }
        if ("edit".equalsIgnoreCase(action)) {
            return this.doEdit(request, response, treeCmd, errors);
        }
        if ("cancel".equalsIgnoreCase(action)) {
            return this.doCancel(request, response, treeCmd, errors);
        }
        if ("delete".equalsIgnoreCase(action)) {
            return this.doDelete(request, response, treeCmd, errors);
        }
        if ("import".equalsIgnoreCase(action)) {
            return this.doImport(request, response, treeCmd, errors);
        }
        if ("done".equalsIgnoreCase(action)) {
            return this.done(request, response, treeCmd, errors);
        }
        errors.reject("Unrecognized action: " + action);
        return this.showForm(request, response, errors);
    }

    private ModelAndView done(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        return new ModelAndView(this.getSuccessView());
    }

    private ModelAndView doShow(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        return this.showForm(request, response, errors);
    }

    private ModelAndView doCancel(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        Requisition formData = this.m_provisioningService.getProvisioningGroup(treeCmd.getGroupName());
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode("");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doImport(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        this.m_provisioningService.importProvisioningGroup(treeCmd.getGroupName());
        return super.showForm(request, response, errors);
    }

    private ModelAndView doDelete(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        Requisition formData = this.m_provisioningService.deletePath(treeCmd.getGroupName(), treeCmd.getDataPath());
        treeCmd.setFormData(formData);
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddCategory(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        Requisition formData = this.m_provisioningService.addCategoryToNode(treeCmd.getGroupName(), treeCmd.getDataPath(), "New Category");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".category[0]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddAssetField(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        Requisition formData = this.m_provisioningService.addAssetFieldToNode(treeCmd.getGroupName(), treeCmd.getDataPath(), "key", "value");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".asset[0]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doEdit(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        treeCmd.setCurrentNode(treeCmd.getFormPath());
        return this.showForm(request, response, errors);
    }

    private ModelAndView doSave(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        try {
            LOG.debug("treeCmd = {}", (Object)treeCmd);
            treeCmd.getFormData().validate();
            Requisition formData = this.m_provisioningService.saveProvisioningGroup(treeCmd.getGroupName(), treeCmd.getFormData());
            treeCmd.setFormData(formData);
            treeCmd.setCurrentNode("");
        }
        catch (Throwable t) {
            errors.reject(t.getMessage());
        }
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddService(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        Requisition formData = this.m_provisioningService.addServiceToInterface(treeCmd.getGroupName(), treeCmd.getDataPath(), "SVC");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".monitoredService[0]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddInterface(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        Requisition formData = this.m_provisioningService.addInterfaceToNode(treeCmd.getGroupName(), treeCmd.getDataPath(), "");
        treeCmd.setFormData(formData);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".interface[0]");
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddNode(HttpServletRequest request, HttpServletResponse response, TreeCommand treeCmd, BindException errors) throws Exception {
        treeCmd.setFormData(this.m_provisioningService.addNewNodeToGroup(treeCmd.getGroupName(), "New Node"));
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".node[0]");
        return this.showForm(request, response, errors);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        TreeCommand formCommand = new TreeCommand();
        this.initializeTreeCommand(request, formCommand);
        return formCommand;
    }

    private void initializeTreeCommand(HttpServletRequest request, TreeCommand formCommand) throws Exception {
        String groupName = request.getParameter("groupName");
        if (groupName == null) {
            throw new IllegalArgumentException("groupName required");
        }
        Requisition formData = this.m_provisioningService.getProvisioningGroup(groupName);
        if (formData == null) {
            formData = this.m_provisioningService.createProvisioningGroup(groupName);
        }
        formCommand.setFormData(formData);
    }

    protected Map<String, Collection<String>> referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        ArrayList<String> choices = new ArrayList<String>();
        for (PrimaryType type : PrimaryType.getAllTypes()) {
            choices.add(type.getCode());
        }
        map.put("snmpPrimaryChoices", choices);
        ArrayList<String> status = new ArrayList<String>();
        status.add("1");
        status.add("3");
        map.put("statusChoices", status);
        String groupName = request.getParameter("groupName");
        if (groupName != null) {
            ArrayList<String> services = new ArrayList<String>(this.m_provisioningService.getServiceTypeNames(groupName));
            Collections.sort(services);
            map.put("services", services);
        }
        ArrayList<String> categories = new ArrayList<String>(this.m_provisioningService.getNodeCategoryNames());
        Collections.sort(categories);
        ArrayList<String> assetFields = new ArrayList<String>(this.m_provisioningService.getAssetFieldNames());
        Collections.sort(assetFields);
        map.put("categories", categories);
        map.put("assetFields", assetFields);
        return map;
    }

    public static class TreeCommand {
        private String m_formPath;
        private String m_action;
        private Requisition m_formData;
        private String m_currentNode;
        private String m_groupName = "hardcoded";

        public String getAction() {
            return this.m_action;
        }

        public void setAction(String action) {
            this.m_action = action;
        }

        public String getGroupName() {
            return this.m_groupName;
        }

        public void setGroupName(String groupName) {
            this.m_groupName = groupName;
        }

        public Requisition getFormData() {
            return this.m_formData;
        }

        public void setFormData(Requisition importData) {
            this.m_formData = importData;
        }

        public String getFormPath() {
            return this.m_formPath;
        }

        public void setFormPath(String target) {
            this.m_formPath = target;
        }

        public String getCurrentNode() {
            return this.m_currentNode;
        }

        public void setCurrentNode(String node) {
            this.m_currentNode = node;
        }

        public String getDataPath() {
            return this.m_formPath.substring("nodeEditForm.formData.".length());
        }

        public void setDataPath(String path) {
            this.m_formPath = "nodeEditForm.formData." + path;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("action", (Object)this.getAction()).append("currentNode", (Object)this.getCurrentNode()).append("dataPath", (Object)this.getDataPath()).append("formData", (Object)this.getFormData()).append("formPath", (Object)this.getFormPath()).append("groupName", (Object)this.getGroupName()).toString();
        }
    }
}

