/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.svclayer.DistributedStatusService;
import org.opennms.web.svclayer.SimpleWebTable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DistributedStatusSummaryController
extends AbstractController {
    private DistributedStatusService m_distributedStatusService;

    public DistributedStatusService getDistributedStatusService() {
        return this.m_distributedStatusService;
    }

    public void setDistributedStatusService(DistributedStatusService statusService) {
        this.m_distributedStatusService = statusService;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        Date endDate = new Date(calendar.getTimeInMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = new Date(calendar.getTimeInMillis());
        if (this.m_distributedStatusService.getApplicationCount() <= 0) {
            return new ModelAndView("distributedStatusSummaryError", "error", this.createError("No Applications Defined", "No applications have been defined for this system so a summary of application status is impossible to display."));
        }
        SimpleWebTable table = this.m_distributedStatusService.createFacilityStatusTable(startDate, endDate);
        return new ModelAndView("distributedStatusSummary", "webTable", (Object)table);
    }

    private Object createError(String shortDescr, String longDescr) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("shortDescr", shortDescr);
        error.put("longDescr", longDescr);
        return error;
    }
}

