/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.web.filter.NotEqualOrNullFilter;
import org.opennms.web.filter.SQLType;

public class NegativeInterfaceFilter
extends NotEqualOrNullFilter<String> {
    public static final String TYPE = "interfacenot";

    public NegativeInterfaceFilter(InetAddress ipAddress) {
        super(TYPE, SQLType.STRING, "IPADDR", "ipAddr", InetAddressUtils.str((InetAddress)ipAddress));
    }

    @Override
    public String getTextDescription() {
        return "interface is not " + (String)this.getValue();
    }

    @Override
    public String toString() {
        return "<AlarmFactory.NegativeInterfaceFilter: " + this.getDescription() + ">";
    }

    public String getIpAddress() {
        return (String)this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegativeInterfaceFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

