/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.pollerConfig;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollerConfigServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigServlet.class);
    private static final long serialVersionUID = -4273370522387271772L;
    private PollerConfiguration m_pollerConfig = null;
    private CapsdConfiguration m_capsdConfig = null;
    protected String m_redirectSuccess;
    private Map<String, Service> m_pollerServices = new HashMap<String, Service>();
    private Map<String, ProtocolPlugin> m_capsdProtocols = new HashMap<String, ProtocolPlugin>();
    private List<ProtocolPlugin> m_capsdColl = new ArrayList<ProtocolPlugin>();
    private Package m_pkg = null;
    private List<ProtocolPlugin> m_pluginColl = null;
    private Properties m_props = new Properties();

    public void init() throws ServletException {
        this.getInitParameters();
        this.loadPollerConfProperties();
        this.initPollerConfigFactory();
        this.initCapsdConfigFactory();
        this.initPollerServices();
        this.initCapsdProtocols();
    }

    private void getInitParameters() throws ServletException {
        ServletConfig config = this.getServletConfig();
        this.m_redirectSuccess = config.getInitParameter("redirect.success");
        if (this.m_redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    private void initCapsdConfigFactory() throws ServletException {
        try {
            CapsdConfigFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        CapsdConfig capsdFactory = CapsdConfigFactory.getInstance();
        this.m_capsdConfig = capsdFactory.getConfiguration();
        if (this.m_capsdConfig == null) {
            throw new ServletException("Capsd Configuration file is empty");
        }
    }

    private void initPollerConfigFactory() throws ServletException {
        try {
            PollerConfigFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        PollerConfig pollerFactory = PollerConfigFactory.getInstance();
        this.m_pollerConfig = pollerFactory.getConfiguration();
        if (this.m_pollerConfig == null) {
            throw new ServletException("Poller Configuration file is empty");
        }
    }

    private void loadPollerConfProperties() throws ServletException {
        try {
            this.m_props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void reloadFiles() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            this.loadPollerConfProperties();
            this.initPollerConfigFactory();
            this.initCapsdConfigFactory();
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        this.initPollerServices();
        this.initCapsdProtocols();
        this.m_redirectSuccess = config.getInitParameter("redirect.success");
        if (this.m_redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void initCapsdProtocols() {
        this.m_pluginColl = this.getCapsdProtocolPlugins();
        if (this.m_pluginColl != null) {
            for (ProtocolPlugin plugin : this.m_pluginColl) {
                this.m_capsdColl.add(plugin);
                this.m_capsdProtocols.put(plugin.getProtocol(), plugin);
            }
        }
    }

    private List<ProtocolPlugin> getCapsdProtocolPlugins() {
        return this.m_capsdConfig.getProtocolPluginCollection();
    }

    public void initPollerServices() {
        Iterator pkgiter;
        List packageColl = this.m_pollerConfig.getPackages();
        if (packageColl != null && (pkgiter = packageColl.iterator()).hasNext()) {
            this.m_pkg = (Package)pkgiter.next();
            List svcColl = this.m_pkg.getServices();
            for (Service svcProp : svcColl) {
                this.m_pollerServices.put(svcProp.getName(), svcProp);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.reloadFiles();
        this.m_props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
        String[] requestActivate = request.getParameterValues("activate");
        String[] requestDelete = request.getParameterValues("delete");
        if (requestActivate != null) {
            for (int i = 0; i < requestActivate.length; ++i) {
                this.modifyPollerInfo("on", requestActivate[i]);
            }
            this.adjustNonChecked(Arrays.asList(requestActivate));
        }
        if (requestDelete != null) {
            this.deleteThese(Arrays.asList(requestDelete));
        }
        OutputStreamWriter poller_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME)), "UTF-8");
        OutputStreamWriter capsd_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME)), "UTF-8");
        try {
            Marshaller.marshal((Object)this.m_pollerConfig, (Writer)poller_fileWriter);
            Marshaller.marshal((Object)this.m_capsdConfig, (Writer)capsd_fileWriter);
        }
        catch (MarshalException e) {
            LOG.error("Could not marshal config object when writing config file: {}", (Object)e, (Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (ValidationException e) {
            LOG.error("Could not validate config object when writing config file: {}", (Object)e, (Object)e);
            throw new ServletException((Throwable)e);
        }
        String redirectPage = request.getParameter("redirect");
        if (redirectPage == null) {
            redirectPage = this.m_redirectSuccess;
        }
        response.sendRedirect(redirectPage);
    }

    public void deleteCapsdInfo(String name) {
        if (this.m_capsdProtocols.get(name) != null) {
            ProtocolPlugin tmpproto = this.m_capsdProtocols.get(name);
            this.m_capsdProtocols.remove(name);
            this.m_pluginColl = new ArrayList<ProtocolPlugin>(this.m_capsdProtocols.values());
            this.m_capsdColl.remove(tmpproto);
            this.m_capsdConfig.setProtocolPlugin(this.m_pluginColl.toArray(new ProtocolPlugin[0]));
        }
    }

    public void adjustNonChecked(List<String> checkedList) {
        List svcColl;
        if (this.m_pkg != null && (svcColl = this.m_pkg.getServices()) != null) {
            for (Service svc : svcColl) {
                if (svc == null || checkedList.contains(svc.getName()) || !svc.getStatus().equals("on")) continue;
                svc.setStatus("off");
            }
        }
    }

    public void deleteThese(List<String> deleteServices) throws IOException {
        block0: for (String svcname : deleteServices) {
            List svcColl;
            if (this.m_pkg == null || (svcColl = this.m_pkg.getServices()) == null) continue;
            for (Service svc : svcColl) {
                if (svc == null || !svc.getName().equals(svcname)) continue;
                this.m_pkg.removeService(svc);
                LOG.info("Package removed {}", (Object)svc.getName());
                this.removeMonitor(svc.getName());
                this.deleteCapsdInfo(svc.getName());
                this.m_props.remove("service." + svc.getName() + ".protocol");
                this.m_props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
                continue block0;
            }
        }
    }

    public void removeMonitor(String service) {
        List monitorColl = this.m_pollerConfig.getMonitors();
        Monitor newMonitor = new Monitor();
        if (monitorColl != null) {
            for (Monitor mon : monitorColl) {
                if (mon == null || !mon.getService().equals(service)) continue;
                newMonitor.setService(service);
                newMonitor.setClassName(mon.getClassName());
                newMonitor.setParameters(mon.getParameters());
                break;
            }
            monitorColl.remove(newMonitor);
        }
    }

    public void modifyPollerInfo(String bPolled, String protocol) {
        List svcColl;
        if (this.m_pkg != null && (svcColl = this.m_pkg.getServices()) != null) {
            for (Service svc : svcColl) {
                if (svc == null || !svc.getName().equals(protocol)) continue;
                svc.setStatus(bPolled);
                break;
            }
        }
    }
}

