/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.pollerConfig;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.web.api.Util;

public class AddPollerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 8025629129971135727L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectSuccess;
        Package firstPackage;
        String user_id = request.getRemoteUser();
        PollerConfiguration pollerConfig = null;
        CapsdConfiguration capsdConfig = null;
        HashMap<String, Service> pollerServices = new HashMap<String, Service>();
        HashMap<String, ProtocolPlugin> capsdProtocols = new HashMap<String, ProtocolPlugin>();
        ArrayList<ProtocolPlugin> capsdColl = new ArrayList<ProtocolPlugin>();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
            PollerConfigFactory.init();
            PollerConfig pollerFactory = PollerConfigFactory.getInstance();
            pollerConfig = pollerFactory.getConfiguration();
            if (pollerConfig == null) {
                throw new ServletException("Poller configuration file is empty");
            }
            CapsdConfigFactory.init();
            CapsdConfig capsdFactory = CapsdConfigFactory.getInstance();
            capsdConfig = capsdFactory.getConfiguration();
            if (capsdConfig == null) {
                throw new ServletException("Capsd configuration file is empty");
            }
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
        pollerServices = new HashMap();
        List packageColl = pollerConfig.getPackages();
        if (packageColl != null && packageColl.size() > 0) {
            firstPackage = (Package)packageColl.iterator().next();
            for (Package pkg : packageColl) {
                for (Service svcProp : pkg.getServices()) {
                    pollerServices.put(svcProp.getName(), svcProp);
                }
            }
        } else {
            throw new ServletException("Poller configuration file contains no packages.");
        }
        List pluginColl = capsdConfig.getProtocolPluginCollection();
        if (pluginColl != null) {
            for (ProtocolPlugin plugin : pluginColl) {
                capsdColl.add(plugin);
                capsdProtocols.put(plugin.getProtocol(), plugin);
            }
        }
        if ((redirectSuccess = this.getServletConfig().getInitParameter("redirect.success")) == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
        String check1 = request.getParameter("check1");
        String name1 = request.getParameter("name1");
        String protoArray1 = request.getParameter("protArray1");
        String port1 = request.getParameter("port1");
        ArrayList<String> checkedList = new ArrayList<String>();
        if (name1 != null && !name1.equals("")) {
            if (!this.addPollerInfo(pollerConfig, firstPackage, props, check1, name1, port1, user_id, protoArray1, response, request)) {
                return;
            }
            checkedList.add(name1);
            if (this.addCapsdInfo(capsdConfig, firstPackage, props, name1, port1, user_id, protoArray1, response, request)) {
                props.setProperty("service." + name1 + ".protocol", protoArray1);
            } else {
                return;
            }
        }
        props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
        OutputStreamWriter poller_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME)), "UTF-8");
        OutputStreamWriter capsd_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME)), "UTF-8");
        try {
            Marshaller.marshal((Object)pollerConfig, (Writer)poller_fileWriter);
            Marshaller.marshal((Object)capsdConfig, (Writer)capsd_fileWriter);
        }
        catch (MarshalException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ServletException((Throwable)e);
        }
        response.sendRedirect(redirectSuccess);
    }

    private boolean addCapsdInfo(CapsdConfiguration capsdConfig, Package pkg, Properties props, String name, String port, String user, String protocol, HttpServletResponse response, HttpServletRequest request) throws ServletException, IOException {
        block0: for (ProtocolPlugin svc : capsdConfig.getProtocolPluginCollection()) {
            if (!svc.getProtocol().equals(name)) continue;
            for (Service pollersvc : pkg.getServices()) {
                if (!pollersvc.getName().equals(name)) continue;
                List tmpPoller = pkg.getServices();
                if (!tmpPoller.contains(pollersvc) || !pollersvc.getName().equals(name)) break block0;
                tmpPoller.remove(pollersvc);
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("/admin/error.jsp?error=1&name=" + name)));
                return false;
            }
        }
        ProtocolPlugin pluginAdd = new ProtocolPlugin();
        pluginAdd.setProtocol(name);
        String className = (String)props.get("service." + protocol + ".capsd-class");
        if (className != null) {
            pluginAdd.setClassName(className);
            pluginAdd.setScan("on");
            pluginAdd.setUserDefined("true");
            Property newprop = new Property();
            String banner = "*";
            if (props.get("banner") != null) {
                banner = (String)props.get("banner");
            }
            newprop.setValue(banner);
            newprop.setKey("banner");
            pluginAdd.addProperty(newprop);
            newprop = new Property();
            if (port != null && !port.equals("")) {
                newprop.setValue(port);
                if (port.indexOf(58) == -1) {
                    newprop.setKey("port");
                } else {
                    newprop.setKey("ports");
                }
                pluginAdd.addProperty(newprop);
            } else {
                if (props.get("service." + protocol + ".port") == null || ((String)props.get("service." + protocol + ".port")).equals("")) {
                    response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".port")));
                    return false;
                }
                port = (String)props.get("service." + protocol + ".port");
                newprop.setValue(port);
                if (port.indexOf(58) == -1) {
                    newprop.setKey("port");
                } else {
                    newprop.setKey("ports");
                }
                pluginAdd.addProperty(newprop);
            }
            newprop = new Property();
            String timeout = "3000";
            if (props.get("timeout") != null) {
                timeout = (String)props.get("timeout");
            }
            newprop.setValue(timeout);
            newprop.setKey("timeout");
            pluginAdd.addProperty(newprop);
            newprop = new Property();
            String retry = "3";
            if (props.get("retry") != null) {
                retry = (String)props.get("retry");
            }
            newprop.setValue(retry);
            newprop.setKey("retry");
            pluginAdd.addProperty(newprop);
            capsdConfig.addProtocolPlugin(pluginAdd);
            return true;
        }
        response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".capsd-class")));
        return false;
    }

    private boolean addPollerInfo(PollerConfiguration pollerConfig, Package pkg, Properties props, String bPolled, String name, String port, String user, String protocol, HttpServletResponse response, HttpServletRequest request) throws ServletException, IOException {
        for (Service svc : pkg.getServices()) {
            if (!svc.getName().equals(name)) continue;
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=1&name=" + name)));
            return false;
        }
        if (pkg != null) {
            Service newService = new Service();
            newService.setName(name);
            if (bPolled != null) {
                newService.setStatus(bPolled);
            } else {
                newService.setStatus("off");
            }
            newService.setName(name);
            newService.setUserDefined("true");
            List monitorColl = pollerConfig.getMonitors();
            Monitor newMonitor = new Monitor();
            String monitor = (String)props.get("service." + protocol + ".monitor");
            if (monitor == null) {
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".monitor")));
                return false;
            }
            newMonitor.setService(name);
            newMonitor.setClassName(monitor);
            if (props.get("interval") != null) {
                newService.setInterval(Long.valueOf(new Long((String)props.get("interval"))));
            } else {
                newService.setInterval(Integer.valueOf(300000));
            }
            Parameter newprop = new Parameter();
            String timeout = "3000";
            if (props.get("timeout") != null) {
                timeout = (String)props.get("timeout");
            }
            newprop.setValue(timeout);
            newprop.setKey("timeout");
            newService.addParameter(newprop);
            newprop = new Parameter();
            String banner = "*";
            if (props.get("banner") != null) {
                banner = (String)props.get("banner");
            }
            newprop.setValue(banner);
            newprop.setKey("banner");
            newService.addParameter(newprop);
            newprop = new Parameter();
            String retry = "3";
            if (props.get("retry") != null) {
                retry = (String)props.get("retry");
            }
            newprop.setValue(retry);
            newprop.setKey("retry");
            newService.addParameter(newprop);
            newprop = new Parameter();
            if (port == null || port.equals("")) {
                if (props.get("service." + protocol + ".port") == null || ((String)props.get("service." + protocol + ".port")).equals("")) {
                    newMonitor = null;
                    newService = null;
                    response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".port")));
                    return false;
                }
                port = (String)props.get("service." + protocol + ".port");
            }
            newprop.setValue(port);
            if (port.indexOf(58) != -1) {
                newprop.setKey("ports");
            } else {
                newprop.setKey("port");
            }
            if (newMonitor != null && newService != null) {
                List monitors = pollerConfig.getMonitors();
                if (monitorColl == null) {
                    monitors.add(0, newMonitor);
                } else {
                    monitors.add(newMonitor);
                }
                pollerConfig.setMonitors(monitors);
                newService.addParameter(newprop);
                pkg.addService(newService);
            }
        }
        return true;
    }
}

